/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.world.builtin_entities;

import bottomtextdanny.braincell.base.scheduler.IntScheduler;
import bottomtextdanny.braincell.mod.entity.modules.animatable.Animation;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationGetter;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationHandler;
import bottomtextdanny.braincell.mod.entity.modules.animatable.LivingAnimatableModule;
import bottomtextdanny.braincell.mod.entity.modules.animatable.LivingAnimatableProvider;
import bottomtextdanny.braincell.mod.entity.modules.data_manager.BCDataManager;
import bottomtextdanny.braincell.mod.entity.modules.data_manager.BCDataManagerProvider;
import bottomtextdanny.braincell.mod.entity.modules.looped_walk.LoopedWalkModule;
import bottomtextdanny.braincell.mod.entity.modules.looped_walk.LoopedWalkProvider;
import bottomtextdanny.braincell.mod.entity.modules.variable.IndexedVariableModule;
import bottomtextdanny.braincell.mod.entity.modules.variable.VariantProvider;
import bottomtextdanny.braincell.mod.world.entity_utilities.EntityClientMessenger;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;

public abstract class ModuledMob
extends PathfinderMob
implements EntityClientMessenger,
BCDataManagerProvider,
LoopedWalkProvider,
LivingAnimatableProvider,
VariantProvider {
    private BCDataManager deDataManager;
    public AnimationHandler<ModuledMob> mainHandler;
    @Deprecated
    public IntScheduler livingSoundTimer = IntScheduler.ranged(800, 1200);
    @Nullable
    protected LoopedWalkModule loopedWalkModule;
    @Nullable
    protected IndexedVariableModule variableModule;
    protected LivingAnimatableModule animatableModule;

    public ModuledMob(EntityType<? extends PathfinderMob> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.animatableModule = new LivingAnimatableModule((LivingEntity)this, this.getAnimations());
        if (this.operateAnimatableModule()) {
            this.mainHandler = this.addAnimationHandler(new AnimationHandler<ModuledMob>(this));
        }
        this.deDataManager = new BCDataManager((Entity)this);
        this.commonInit();
    }

    protected void commonInit() {
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
    }

    @Override
    public LoopedWalkModule loopedWalkModule() {
        return this.loopedWalkModule;
    }

    @Override
    public boolean operateWalkModule() {
        return this.loopedWalkModule != null;
    }

    @Override
    public void playLoopStepSound(BlockPos pos, BlockState blockIn) {
        this.playStepSound(pos, blockIn, Math.min(this.loopedWalkModule().renderLimbSwingAmount * 8.0f, 1.0f));
    }

    @Override
    public float getLoopWalkMultiplier() {
        return 0.25f;
    }

    @Override
    public float hurtLoopLimbSwingFactor() {
        return 0.25f;
    }

    public AnimationGetter getAnimations() {
        return null;
    }

    @Override
    public LivingAnimatableModule animatableModule() {
        return this.animatableModule;
    }

    @Override
    @Nullable
    public Animation<?> getDeathAnimation() {
        return null;
    }

    @Override
    public IndexedVariableModule variableModule() {
        return this.variableModule;
    }

    protected final void m_8099_() {
        super.m_8099_();
        this.registerExtraGoals();
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
    }

    public void m_8119_() {
        super.m_8119_();
        this.f_19853_.m_46473_().m_6180_("BC:dannyBaseTick");
        if (!this.f_19853_.m_5776_()) {
            if (this.getLivingSoundTimer().hasEnded()) {
                this.doLivingSound();
                this.getLivingSoundTimer().reset();
            } else {
                this.getLivingSoundTimer().advance();
            }
        }
        this.f_19853_.m_46473_().m_7238_();
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        return super.m_6972_(poseIn);
    }

    protected void registerExtraGoals() {
    }

    public void m_147240_(double strength, double ratioX, double ratioZ) {
        LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)this, (float)((float)strength), (double)ratioX, (double)ratioZ);
        if (event.isCanceled()) {
            return;
        }
        float resistantFactor = (float)(1.0 - this.m_21133_(Attributes.f_22278_));
        strength = event.getStrength();
        ratioX = event.getRatioX();
        ratioZ = event.getRatioZ();
        if (!((strength *= (double)resistantFactor) <= 0.0)) {
            this.f_19812_ = true;
            Vec3 motionFactor = this.m_20184_();
            Vec3 knockBackFactor = this.modifyKnockBack(new Vec3(ratioX, 0.0, ratioZ).m_82541_().m_82490_(strength)).m_82520_(0.0, 0.4 * (double)resistantFactor, 0.0);
            this.m_20256_(new Vec3(motionFactor.f_82479_ / 2.0 - knockBackFactor.f_82479_, this.f_19861_ ? Math.max(knockBackFactor.f_82480_, motionFactor.f_82480_) : motionFactor.f_82480_, motionFactor.f_82481_ / 2.0 - knockBackFactor.f_82481_));
        }
    }

    public Vec3 modifyKnockBack(Vec3 knockback) {
        return knockback;
    }

    public abstract boolean m_6785_(double var1);

    @Nullable
    public SoundEvent getLivingSound() {
        return super.m_7515_();
    }

    public void playLivingSound() {
        SoundEvent soundevent = this.getLivingSound();
        if (soundevent != null) {
            this.m_5496_(soundevent, 1.0f, 0.8f + this.f_19796_.nextFloat() * 0.4f);
        }
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        super.m_7355_(pos, blockIn);
    }

    public IntScheduler getLivingSoundTimer() {
        return this.livingSoundTimer;
    }

    public void playStepSound(BlockPos pos, BlockState blockIn, float volume) {
        if (!blockIn.m_60767_().m_76332_()) {
            BlockState blockstate = this.f_19853_.m_8055_(pos.m_7494_());
            SoundType soundtype = blockstate.m_60713_(Blocks.f_50125_) ? blockstate.getSoundType((LevelReader)this.f_19853_, pos, (Entity)this) : blockIn.getSoundType((LevelReader)this.f_19853_, pos, (Entity)this);
            this.m_5496_(soundtype.m_56776_(), soundtype.m_56773_() * 0.15f * volume, soundtype.m_56774_());
        }
    }

    @ParametersAreNonnullByDefault
    public boolean m_5545_(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return true;
    }

    protected boolean m_8028_() {
        return true;
    }

    public void doLivingSound() {
        this.playLivingSound();
    }

    @Override
    public BCDataManager bcDataManager() {
        return this.deDataManager;
    }
}

