/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.world.builtin_entities;

import bottomtextdanny.braincell.base.ObjectFetcher;
import bottomtextdanny.braincell.mod._base.serialization.WorldPacketData;
import bottomtextdanny.braincell.mod._base.serialization.builtin.BuiltinSerializers;
import bottomtextdanny.braincell.mod.entity.modules.data_manager.BCDataManager;
import bottomtextdanny.braincell.mod.entity.modules.data_manager.BCDataManagerProvider;
import bottomtextdanny.braincell.mod.entity.serialization.EntityData;
import bottomtextdanny.braincell.mod.entity.serialization.EntityDataReference;
import bottomtextdanny.braincell.mod.entity.serialization.RawEntityDataReference;
import bottomtextdanny.braincell.mod.world.builtin_entities.BCBoatType;
import bottomtextdanny.braincell.mod.world.builtin_items.BCBoatItem;
import bottomtextdanny.braincell.mod.world.entity_utilities.EntityClientMessenger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.protocol.Packet;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;

public class BCBoat
extends Boat
implements BCDataManagerProvider,
EntityClientMessenger {
    public static final int UPDATE_TEXTURE_CALL = 0;
    public static final EntityDataReference<Item> DATA_REF = BCDataManager.attribute(BCBoat.class, RawEntityDataReference.of(BuiltinSerializers.ITEM, () -> Items.f_41852_, "boat_item"));
    private final EntityData<Item> boatItem;
    private final BCDataManager deDataManager = new BCDataManager((Entity)this);

    public BCBoat(EntityType<? extends Boat> type, Level world) {
        super(type, world);
        this.boatItem = this.bcDataManager().addSyncedData(EntityData.of(DATA_REF));
    }

    public void setBoatItem(BCBoatItem item) {
        this.boatItem.set(item);
    }

    @Override
    public void clientCallOutHandler(int flag, ObjectFetcher fetcher) {
        if (flag == 0) {
            this.setClientBoatItem(fetcher.get(0, Integer.class));
        }
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        this.f_38281_ = this.m_20184_().f_82480_;
        if (!this.m_20159_()) {
            if (onGroundIn) {
                if (this.f_19789_ > 3.0f) {
                    if (this.f_38279_ != Boat.Status.ON_LAND) {
                        this.f_19789_ = 0.0f;
                        return;
                    }
                    this.m_142535_(this.f_19789_, 1.0f, DamageSource.f_19315_);
                    if (!this.f_19853_.f_46443_ && !this.m_146910_()) {
                        this.m_142687_(Entity.RemovalReason.KILLED);
                        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                            ItemEntity plankEntity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)this.getBCBoatType().materialItem.get(), 3));
                            ItemEntity stickEntity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)Items.f_42398_, 2));
                            plankEntity.m_32060_();
                            stickEntity.m_32060_();
                            if (this.captureDrops() != null) {
                                this.captureDrops().add(plankEntity);
                                this.captureDrops().add(stickEntity);
                            } else {
                                this.f_19853_.m_7967_((Entity)plankEntity);
                                this.f_19853_.m_7967_((Entity)stickEntity);
                            }
                        }
                    }
                }
                this.f_19789_ = 0.0f;
            } else if (!this.f_19853_.m_6425_(this.m_142538_().m_7495_()).m_205070_(FluidTags.f_13131_) && y < 0.0) {
                this.f_19789_ = (float)((double)this.f_19789_ - y);
            }
        }
    }

    protected void setLastYd(double newLastYd) {
        this.f_38281_ = newLastYd;
    }

    protected double getLastYd() {
        return this.f_38281_;
    }

    public void updateClientTexture() {
        if (!this.f_19853_.m_5776_()) {
            this.sendClientMsg(0, PacketDistributor.TRACKING_ENTITY.with(() -> this), new WorldPacketData[]{WorldPacketData.of(BuiltinSerializers.INTEGER, Item.m_41393_((Item)this.boatItem.get()))});
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setClientBoatItem(int transientId) {
        this.boatItem.set((Item)Registry.f_122827_.m_7942_(transientId));
    }

    public BCBoatType getBCBoatType() {
        BCBoatType bCBoatType;
        Item item = this.boatItem.get();
        if (item instanceof BCBoatItem) {
            BCBoatItem boatItem = (BCBoatItem)item;
            bCBoatType = boatItem.getType();
        } else {
            bCBoatType = BCBoatType.INVALID;
        }
        return bCBoatType;
    }

    public Item m_38369_() {
        return this.getBCBoatType().materialItem.get();
    }

    @Override
    public BCDataManager bcDataManager() {
        return this.deDataManager;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

