/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.world.builtin_blocks;

import bottomtextdanny.braincell.mod._base.registry.block_extensions.ExtraBlockRegisterer;
import bottomtextdanny.braincell.mod._base.registry.managing.DeferrorType;
import bottomtextdanny.braincell.mod._base.registry.managing.ModDeferringManager;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class BCCuttedBlock
extends Block
implements ExtraBlockRegisterer<Block> {
    @Nullable
    private String mask;
    private StairBlock stairs;
    private SlabBlock slab;

    public BCCuttedBlock(BlockBehaviour.Properties properties, String mask) {
        super(properties);
        this.mask = mask;
    }

    public BCCuttedBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.mask = null;
    }

    public SlabBlock slab() {
        return this.slab;
    }

    public StairBlock stairs() {
        return this.stairs;
    }

    @Override
    public void registerExtra(Block object, ModDeferringManager solving) {
        solving.getRegistryDeferror(DeferrorType.BLOCK).ifPresent(registry -> {
            if (this.mask == null) {
                this.mask = object.getRegistryName().m_135815_();
            }
            this.stairs = new StairBlock(object.m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)object));
            this.stairs.setRegistryName(this.mask + "_stairs");
            solving.doHooksForObject(DeferrorType.BLOCK, this.stairs);
            registry.addDeferredRegistry(() -> this.stairs);
            this.slab = new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)object));
            this.slab.setRegistryName(this.mask + "_slab");
            solving.doHooksForObject(DeferrorType.BLOCK, this.slab);
            registry.addDeferredRegistry(() -> this.slab);
            this.mask = null;
        });
    }
}

