/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.rendering.modeling;

import bottomtextdanny.braincell.base.BCMath;
import bottomtextdanny.braincell.mod._base.BCStaticData;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.BCJoint;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.BCModel;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.ModelSectionReseter;
import bottomtextdanny.braincell.mod.entity.modules.looped_walk.LoopedWalkProvider;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class BCEntityModel<E extends Entity>
extends EntityModel<E>
implements BCModel {
    private final List<ModelSectionReseter> reseters = Lists.newArrayList();
    private final List<BCJoint> joints = Lists.newArrayList();
    public int texWidth;
    public int texHeight;
    private E host;

    protected BCEntityModel() {
    }

    public void m_6973_(E entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.host = entityIn;
        this.runDefaultState();
        this.handleRotations(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.handleKeyframedAnimations(entityIn, limbSwing, limbSwingAmount, netHeadYaw, headPitch);
    }

    public void handleRotations(E entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
    }

    public void handleKeyframedAnimations(E entity, float limbSwing, float limbSwingAmount, float headYaw, float headPitch) {
    }

    public static <D extends LoopedWalkProvider> float caculateLimbSwingEasing(D entity) {
        return entity.operateWalkModule() ? BCMath.loopLerp(BCStaticData.partialTick(), 1.0f, entity.loopedWalkModule().prevLimbSwingLoop, entity.loopedWalkModule().limbSwingLoop) : 0.0f;
    }

    public static <D extends LoopedWalkProvider> float caculateLimbSwingAmountEasing(D entity) {
        return entity.operateWalkModule() ? Mth.m_14179_((float)BCStaticData.partialTick(), (float)entity.loopedWalkModule().prevRenderLimbSwingAmount, (float)entity.loopedWalkModule().renderLimbSwingAmount) : 0.0f;
    }

    public void m_6839_(E entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.host = entityIn;
        super.m_6839_(entityIn, limbSwing, limbSwingAmount, partialTick);
    }

    @Override
    public void runDefaultState() {
        this.reseters.forEach(r -> r.reset(this));
    }

    @Override
    public void addReseter(ModelSectionReseter model) {
        this.reseters.add(model);
    }

    @Override
    public List<BCJoint> getJoints() {
        return Collections.unmodifiableList(this.joints);
    }

    @Override
    public boolean addJoint(BCJoint joint) {
        return this.joints.add(joint);
    }

    public void setOffset(BCJoint part, float x, float y, float z) {
        part.x = x;
        part.y = y;
        part.z = z;
    }

    public void setSize(BCJoint part, float x, float y, float z) {
        part.scaleX = x;
        part.scaleY = y;
        part.scaleZ = z;
    }

    public E getHost() {
        return this.host;
    }

    @Deprecated
    public float walkRotationHelper(float speed, float amount, float desync, float weight, float limbSwing, float limbSwingAmount, boolean invert) {
        return invert ? BCMath.cos(limbSwing * speed + desync * (float)Math.PI) * (-amount * ((float)Math.PI / 180) * 2.0f) * limbSwingAmount + weight * limbSwingAmount * ((float)Math.PI / 180) : BCMath.cos(limbSwing * speed + desync * (float)Math.PI) * (amount * ((float)Math.PI / 180) * 2.0f) * limbSwingAmount + weight * limbSwingAmount * ((float)Math.PI / 180);
    }

    @Deprecated
    public float walkOffsetHelper(float speed, float amount, float desync, float weight, float limbSwing, float limbSwingAmount, boolean invert) {
        return invert ? BCMath.cos(limbSwing * speed + desync * (float)Math.PI) * (-amount * 2.0f) * limbSwingAmount + weight * limbSwingAmount : BCMath.cos(limbSwing * speed + desync * (float)Math.PI) * (amount * 2.0f) * limbSwingAmount + weight * limbSwingAmount;
    }

    @Deprecated
    public void walkRotateX(BCJoint part, float speed, float degrees, float desync, float weight, float limbSwing, float limbSwingAmount, boolean invert) {
        part.xRot += this.walkRotationHelper(speed, degrees, desync, weight, limbSwing, limbSwingAmount, invert);
    }

    @Deprecated
    public void walkRotateY(BCJoint part, float speed, float degrees, float desync, float weight, float limbSwing, float limbSwingAmount, boolean invert) {
        part.yRot += this.walkRotationHelper(speed, degrees, desync, weight, limbSwing, limbSwingAmount, invert);
    }

    @Deprecated
    public void walkRotateZ(BCJoint part, float speed, float degrees, float desync, float weight, float limbSwing, float limbSwingAmount, boolean invert) {
        part.zRot += this.walkRotationHelper(speed, degrees, desync, weight, limbSwing, limbSwingAmount, invert);
    }

    @Deprecated
    public void walkOffsetX(BCJoint part, float speed, float amount, float desync, float weight, float limbSwing, float limbSwingAmount, boolean invert) {
        part.x += this.walkOffsetHelper(speed, amount, desync, weight, limbSwing, limbSwingAmount, invert);
    }

    @Deprecated
    public void walkOffsetY(BCJoint part, float speed, float amount, float desync, float weight, float limbSwing, float limbSwingAmount, boolean invert) {
        part.y += this.walkOffsetHelper(speed, amount, desync, weight, limbSwing, limbSwingAmount, invert);
    }

    @Deprecated
    public void walkOffsetZ(BCJoint part, float speed, float amount, float desync, float weight, float limbSwing, float limbSwingAmount, boolean invert) {
        part.z += this.walkOffsetHelper(speed, amount, desync, weight, limbSwing, limbSwingAmount, invert);
    }

    @Deprecated
    public void walkScaleX(BCJoint part, float speed, float amount, float desync, float weight, float limbSwing, float limbSwingAmount, boolean invert) {
        part.scaleX += this.walkOffsetHelper(speed, amount, desync, weight, limbSwing, limbSwingAmount, invert);
    }

    @Deprecated
    public void walkScaleY(BCJoint part, float speed, float amount, float desync, float weight, float limbSwing, float limbSwingAmount, boolean invert) {
        part.scaleY += this.walkOffsetHelper(speed, amount, desync, weight, limbSwing, limbSwingAmount, invert);
    }

    @Deprecated
    public void walkScaleZ(BCJoint part, float speed, float amount, float desync, float weight, float limbSwing, float limbSwingAmount, boolean invert) {
        part.scaleZ += this.walkOffsetHelper(speed, amount, desync, weight, limbSwing, limbSwingAmount, invert);
    }

    @Override
    public int getTexWidth() {
        return this.texWidth;
    }

    @Override
    public int getTexHeight() {
        return this.texHeight;
    }
}

