/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.rendering;

import bottomtextdanny.braincell.Braincell;
import bottomtextdanny.braincell.mod._mod.client_sided.ChestMaterial;
import bottomtextdanny.braincell.mod._mod.client_sided.MaterialManager;
import bottomtextdanny.braincell.mod.rendering.modeling.chest.BCChestModel;
import bottomtextdanny.braincell.mod.world.builtin_block_entities.BCChestBlockEntity;
import bottomtextdanny.braincell.mod.world.builtin_blocks.BCChestBlock;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class BCBaseChestRenderer<T extends BCChestBlockEntity>
implements BlockEntityRenderer<T> {
    protected BCChestModel singleModel;
    protected BCChestModel leftModel;
    protected BCChestModel rightModel;

    public BCBaseChestRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn, BCChestModel singleModel, BCChestModel leftModel, BCChestModel rightModel) {
        this.singleModel = singleModel;
        this.leftModel = leftModel;
        this.rightModel = rightModel;
    }

    public void render(T tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Level world = tileEntityIn.m_58904_();
        boolean worldLoaded = world != null;
        BlockState blockstate = worldLoaded && tileEntityIn.m_58900_().m_60734_() instanceof BCChestBlock ? tileEntityIn.m_58900_() : (BlockState)((BCChestBlockEntity)tileEntityIn).getAuxiliaryBlock().m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.SOUTH);
        ChestType chesttype = blockstate.m_61138_((Property)ChestBlock.f_51479_) ? (ChestType)blockstate.m_61143_((Property)ChestBlock.f_51479_) : ChestType.SINGLE;
        Block block = blockstate.m_60734_();
        if (block instanceof BCChestBlock) {
            BCChestModel model;
            VertexConsumer ivertexbuilder;
            BCChestBlock chestBlock = (BCChestBlock)block;
            MaterialManager materialManager = Braincell.client().getMaterialManager();
            boolean isDouble = chesttype != ChestType.SINGLE;
            DoubleBlockCombiner.NeighborCombineResult icallbackwrapper = worldLoaded ? chestBlock.m_5641_(blockstate, world, tileEntityIn.m_58899_(), true) : DoubleBlockCombiner.Combiner::m_6502_;
            float calledLidDegree = ((Float2FloatFunction)icallbackwrapper.m_5649_(ChestBlock.m_51517_(tileEntityIn))).get(partialTicks);
            int calledFusedLight = ((Int2IntFunction)icallbackwrapper.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(combinedLightIn);
            matrixStackIn.m_85836_();
            matrixStackIn.m_85841_(1.0f, -1.0f, -1.0f);
            matrixStackIn.m_85837_(0.5, 0.0, -0.5);
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(((Direction)blockstate.m_61143_((Property)ChestBlock.f_51478_)).m_122435_()));
            if (isDouble) {
                if (chesttype == ChestType.LEFT) {
                    ivertexbuilder = materialManager.getChestMaterial(chestBlock, ChestMaterial.DOUBLE_LEFT).m_119194_(bufferIn, RenderType::m_110452_);
                    model = this.leftModel;
                } else {
                    ivertexbuilder = materialManager.getChestMaterial(chestBlock, ChestMaterial.DOUBLE_RIGHT).m_119194_(bufferIn, RenderType::m_110452_);
                    model = this.rightModel;
                }
            } else {
                ivertexbuilder = materialManager.getChestMaterial(chestBlock, ChestMaterial.SINGLE).m_119194_(bufferIn, RenderType::m_110452_);
                model = this.singleModel;
            }
            model.runDefaultState();
            model.setRotationWLid((BCChestBlockEntity)tileEntityIn, partialTicks, calledLidDegree);
            model.m_7695_(matrixStackIn, ivertexbuilder, calledFusedLight, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStackIn.m_85849_();
        }
    }
}

