/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.network.stc;

import bottomtextdanny.braincell.mod.entity.modules.looped_walk.LoopedWalkProvider;
import bottomtextdanny.braincell.mod.network.BCEntityPacket;
import bottomtextdanny.braincell.mod.network.BCPacketInitialization;
import bottomtextdanny.braincell.mod.network.Connection;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;

public class MSGTrivialEntityActions
extends BCEntityPacket<MSGTrivialEntityActions, Entity> {
    public static int HIT_EVENT;
    public static final Int2ObjectArrayMap<Consumer<Entity>> EVENT_MAP;
    private final int flag;

    public MSGTrivialEntityActions(int entityId, int flag) {
        super(entityId);
        this.flag = flag;
    }

    @Override
    public MSGTrivialEntityActions deserialize(FriendlyByteBuf stream) {
        return new MSGTrivialEntityActions(stream.readInt(), stream.readInt());
    }

    @Override
    public void serialize(FriendlyByteBuf stream) {
        super.serialize(stream);
        stream.writeInt(this.flag);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void postDeserialization(NetworkEvent.Context ctx, Level world) {
        super.postDeserialization(ctx, world);
        Connection.doClientSide(() -> ((Consumer)EVENT_MAP.get(this.flag)).accept(this.getEntityAsReceptor(world)));
    }

    @Override
    public LogicalSide side() {
        return LogicalSide.CLIENT;
    }

    @Override
    public SimpleChannel mainChannel() {
        return BCPacketInitialization.CHANNEL;
    }

    static {
        EVENT_MAP = (Int2ObjectArrayMap)Util.m_137537_(() -> {
            Int2ObjectArrayMap map = new Int2ObjectArrayMap();
            map.put(HIT_EVENT, entity -> {
                LoopedWalkProvider provider;
                if (entity instanceof LoopedWalkProvider && (provider = (LoopedWalkProvider)entity).operateWalkModule()) {
                    provider.loopedWalkModule().renderLimbSwingAmount += provider.hurtLoopLimbSwingFactor();
                }
            });
            return map;
        });
    }
}

