/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.network.stc;

import bottomtextdanny.braincell.mod.entity.modules.animatable.BaseAnimatableModule;
import bottomtextdanny.braincell.mod.entity.modules.animatable.BaseAnimatableProvider;
import bottomtextdanny.braincell.mod.network.BCEntityPacket;
import bottomtextdanny.braincell.mod.network.BCPacketInitialization;
import bottomtextdanny.braincell.mod.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;

public final class MSGEntityAnimation
extends BCEntityPacket<MSGEntityAnimation, Entity> {
    private final int handlerIndex;
    private final int animationIndex;

    public MSGEntityAnimation(int entityId, int moduleIndex, int animationIndex) {
        super(entityId);
        this.handlerIndex = moduleIndex;
        this.animationIndex = animationIndex;
    }

    @Override
    public void serialize(FriendlyByteBuf stream) {
        super.serialize(stream);
        stream.writeInt(this.handlerIndex);
        stream.writeInt(this.animationIndex);
    }

    @Override
    public MSGEntityAnimation deserialize(FriendlyByteBuf stream) {
        return new MSGEntityAnimation(stream.readInt(), stream.readInt(), stream.readInt());
    }

    @Override
    public void postDeserialization(NetworkEvent.Context ctx, Level world) {
        Connection.doClientSide(() -> {
            BaseAnimatableProvider provider;
            Object entity = this.getEntityAsReceptor(world);
            if (entity instanceof BaseAnimatableProvider && (provider = (BaseAnimatableProvider)entity).operateAnimatableModule()) {
                ((BaseAnimatableModule)provider.animatableModule()).animationHandlerList().get(this.handlerIndex).play(((BaseAnimatableModule)provider.animatableModule()).animationManager().getAnimation(this.animationIndex));
            }
        });
    }

    @Override
    public LogicalSide side() {
        return LogicalSide.CLIENT;
    }

    @Override
    public SimpleChannel mainChannel() {
        return BCPacketInitialization.CHANNEL;
    }
}

