/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.network.stc;

import bottomtextdanny.braincell.Braincell;
import bottomtextdanny.braincell.base.ObjectFetcher;
import bottomtextdanny.braincell.mod._base.serialization.SerializerMark;
import bottomtextdanny.braincell.mod._base.serialization.WorldPacketData;
import bottomtextdanny.braincell.mod._base.serialization.util.H_WorldDataParser;
import bottomtextdanny.braincell.mod.network.BCPacket;
import bottomtextdanny.braincell.mod.network.BCPacketInitialization;
import bottomtextdanny.braincell.mod.network.Connection;
import bottomtextdanny.braincell.mod.world.block_entity_utilities.BlockEntityClientMessenger;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;

public final class MSGBlockEntityClientMessenger
implements BCPacket<MSGBlockEntityClientMessenger> {
    private final BlockPos pos;
    private final int flag;
    private WorldPacketData<?>[] serverObjects;
    private ServerLevel serverLevel;
    private Object[] clientObjects;

    @OnlyIn(value=Dist.CLIENT)
    public MSGBlockEntityClientMessenger(FriendlyByteBuf stream) {
        this.pos = BlockPos.m_122022_((long)stream.readLong());
        this.flag = stream.readInt();
        int size = stream.readInt();
        this.clientObjects = new Object[size];
        Connection.doClientSide(() -> {
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    SerializerMark<?> serializer;
                    int serializerId = stream.readInt();
                    if (serializerId == -1 || (serializer = Braincell.common().getSerializerLookUp().getSerializerFromId(serializerId)) == null) continue;
                    this.clientObjects[i] = H_WorldDataParser.readDataFromPacket(stream, serializer, (Level)Minecraft.m_91087_().f_91073_);
                }
            }
        });
    }

    public MSGBlockEntityClientMessenger(BlockPos blockPosition, int flag, ServerLevel level, @Nullable WorldPacketData<?>[] objects) {
        this.pos = blockPosition;
        this.flag = flag;
        this.serverObjects = objects;
        this.serverLevel = level;
    }

    @Override
    public void serialize(FriendlyByteBuf stream) {
        stream.writeLong(this.pos.m_121878_());
        stream.writeInt(this.flag);
        if (this.serverObjects == null) {
            stream.writeInt(0);
        } else {
            stream.writeInt(this.serverObjects.length);
            for (WorldPacketData<?> object : this.serverObjects) {
                if (object != null) {
                    stream.writeInt(Braincell.common().getSerializerLookUp().getIdFromSerializer(object.getSerializer()));
                    object.writeToStream(stream, (Level)this.serverLevel);
                    continue;
                }
                stream.writeInt(-1);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public MSGBlockEntityClientMessenger deserialize(FriendlyByteBuf stream) {
        return new MSGBlockEntityClientMessenger(stream);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void postDeserialization(NetworkEvent.Context ctx, Level world) {
        Connection.doClientSide(() -> {
            BlockEntity patt4142$temp = world.m_7702_(this.pos);
            if (patt4142$temp instanceof BlockEntityClientMessenger) {
                BlockEntityClientMessenger blockEntity = (BlockEntityClientMessenger)patt4142$temp;
                blockEntity.clientCallOutHandler(this.flag, ObjectFetcher.of(this.clientObjects));
            }
        });
    }

    @Override
    public LogicalSide side() {
        return LogicalSide.CLIENT;
    }

    @Override
    public SimpleChannel mainChannel() {
        return BCPacketInitialization.CHANNEL;
    }
}

