/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.network.cts;

import bottomtextdanny.braincell.Braincell;
import bottomtextdanny.braincell.base.ObjectFetcher;
import bottomtextdanny.braincell.mod._base.serialization.SerializerMark;
import bottomtextdanny.braincell.mod._base.serialization.WorldPacketData;
import bottomtextdanny.braincell.mod._base.serialization.util.H_WorldDataParser;
import bottomtextdanny.braincell.mod.capability.BCCapabilityHelper;
import bottomtextdanny.braincell.mod.capability.player.BCAccessoryModule;
import bottomtextdanny.braincell.mod.capability.player.accessory.HandAccessories;
import bottomtextdanny.braincell.mod.capability.player.accessory.StackAccessory;
import bottomtextdanny.braincell.mod.network.BCPacket;
import bottomtextdanny.braincell.mod.network.BCPacketInitialization;
import bottomtextdanny.braincell.mod.network.Connection;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;

public final class MSGHandAccessoryServerMessenger
implements BCPacket<MSGHandAccessoryServerMessenger> {
    private final byte handOrdinal;
    private final int flag;
    private WorldPacketData<?>[] packetObjects;
    private FriendlyByteBuf stream;
    private Object[] objects;

    public MSGHandAccessoryServerMessenger(FriendlyByteBuf stream) {
        this.handOrdinal = stream.readByte();
        this.flag = stream.readInt();
        this.stream = stream;
    }

    public MSGHandAccessoryServerMessenger(byte handOrdinal, int flag, WorldPacketData<?>[] objects) {
        this.handOrdinal = handOrdinal;
        this.flag = flag;
        this.packetObjects = objects;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void serialize(FriendlyByteBuf stream) {
        stream.writeByte((int)this.handOrdinal);
        stream.writeInt(this.flag);
        Connection.doClientSide(() -> {
            if (this.packetObjects == null) {
                stream.writeInt(0);
            } else {
                int bound = Math.min(5, this.packetObjects.length);
                stream.writeInt(bound);
                for (int i = 0; i < bound; ++i) {
                    WorldPacketData<?> object = this.packetObjects[i];
                    if (object != null) {
                        stream.writeInt(Braincell.common().getSerializerLookUp().getIdFromSerializer(object.getSerializer()));
                        object.writeToStream(stream, (Level)Minecraft.m_91087_().f_91073_);
                        continue;
                    }
                    stream.writeInt(-1);
                }
            }
        });
    }

    @Override
    public MSGHandAccessoryServerMessenger deserialize(FriendlyByteBuf stream) {
        return new MSGHandAccessoryServerMessenger(stream);
    }

    @Override
    public void postDeserialization(NetworkEvent.Context ctx, Level world) {
        ServerPlayer player = ctx.getSender();
        if (player != null) {
            int size = this.stream.readInt();
            this.objects = new Object[size];
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    int serializerId = this.stream.readInt();
                    SerializerMark<?> serializer = Braincell.common().getSerializerLookUp().getSerializerFromId(serializerId);
                    if (serializer == null) continue;
                    this.objects[i] = H_WorldDataParser.readDataFromPacket(this.stream, serializer, world);
                }
            }
            BCAccessoryModule accessoryModule = BCCapabilityHelper.accessoryModule((Player)player);
            if (this.handOrdinal >= 0 && this.handOrdinal < 2) {
                ((StackAccessory)((Function)HandAccessories.ACCESSORY_FOR_HAND.get((int)this.handOrdinal)).apply(accessoryModule)).accessoryServerManager(this.flag, ObjectFetcher.of(this.objects));
            }
        }
    }

    @Override
    public LogicalSide side() {
        return LogicalSide.SERVER;
    }

    @Override
    public SimpleChannel mainChannel() {
        return BCPacketInitialization.CHANNEL;
    }
}

