/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.network;

import java.util.function.Supplier;
import net.minecraftforge.fml.loading.FMLLoader;

public final class Connection {
    public static <T> T makeServerSide(Supplier<T> objectSupplier) {
        if (FMLLoader.getDist().isDedicatedServer()) {
            return objectSupplier.get();
        }
        return null;
    }

    public static Object makeServerSideUnknown(Supplier<?> objectSupplier) {
        if (FMLLoader.getDist().isDedicatedServer()) {
            return objectSupplier.get();
        }
        return null;
    }

    public static <T> T makeServerSideOrElse(Supplier<? extends T> objectSupplier, Supplier<? extends T> fallbackSupplier) {
        if (FMLLoader.getDist().isDedicatedServer()) {
            return objectSupplier.get();
        }
        return fallbackSupplier.get();
    }

    public static void doServerSide(Runnable action) {
        if (FMLLoader.getDist().isDedicatedServer()) {
            action.run();
        }
    }

    public static <T> T makeClientSide(Supplier<T> objectSupplier) {
        if (FMLLoader.getDist().isClient()) {
            return objectSupplier.get();
        }
        return null;
    }

    public static Object makeClientSideUnknown(Supplier<?> objectSupplier) {
        if (FMLLoader.getDist().isClient()) {
            return objectSupplier.get();
        }
        return null;
    }

    public static <T> T makeClientSideOrElse(Supplier<? extends T> objectSupplier, Supplier<? extends T> fallbackSupplier) {
        if (FMLLoader.getDist().isClient()) {
            return objectSupplier.get();
        }
        return fallbackSupplier.get();
    }

    public static void doClientSide(Runnable action) {
        if (FMLLoader.getDist().isClient()) {
            action.run();
        }
    }

    private Connection() {
    }
}

