/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.network;

import bottomtextdanny.braincell.mod.network.Connection;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public interface BCPacket<T extends BCPacket<T>> {
    public void serialize(FriendlyByteBuf var1);

    public T deserialize(FriendlyByteBuf var1);

    default public void postDeserialization(NetworkEvent.Context ctx, Level world) {
    }

    public LogicalSide side();

    default public void sendToServer() {
        if (this.side() == LogicalSide.CLIENT) {
            throw new IllegalStateException("Attempted to send a client-configured packet to server.");
        }
        this.mainChannel().sendToServer((Object)this);
    }

    default public void sendTo(PacketDistributor.PacketTarget target) {
        if (this.side() == LogicalSide.SERVER) {
            throw new IllegalStateException("Attempted to send a server-configured packet to client.");
        }
        this.mainChannel().send(target, (Object)this);
    }

    public SimpleChannel mainChannel();

    @Nullable
    default public Level worldProvider(NetworkEvent.Context ctx) {
        if (this.side() == LogicalSide.SERVER) {
            return ctx.getSender().f_19853_;
        }
        return (Level)Connection.makeClientSideUnknown(() -> Minecraft.m_91087_().f_91073_);
    }

    default public void _serializeHandler(T packet, FriendlyByteBuf stream) {
        packet.serialize(stream);
    }

    default public void _postDeserializationHandler(T packet, Supplier<NetworkEvent.Context> ctx) {
        Level world;
        if (ctx.get().getDirection().getReceptionSide() == this.side() && (world = packet.worldProvider(ctx.get())) != null) {
            ctx.get().enqueueWork(() -> {
                packet.postDeserialization((NetworkEvent.Context)ctx.get(), world);
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            });
        }
    }
}

