/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.hooks;

import bottomtextdanny.braincell.mod._base.BCEvaluations;
import bottomtextdanny.braincell.mod.capability.BCCapabilityHelper;
import bottomtextdanny.braincell.mod.capability.player.BCAccessoryModule;
import bottomtextdanny.braincell.mod.capability.player.accessory.extensions.FinnFall;
import java.util.Comparator;
import java.util.Objects;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import org.apache.commons.lang3.mutable.MutableFloat;

public final class BCMovementHooks {
    public static void livingFallHook(LivingFallEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            BCMovementHooks.playerFallHook(player, event);
        }
    }

    private static void playerFallHook(Player player, LivingFallEvent event) {
        BCAccessoryModule accessoryModule = BCCapabilityHelper.accessoryModule(player);
        MutableFloat damageTransformer = new MutableFloat(event.getDamageMultiplier());
        MutableFloat distanceTransformer = new MutableFloat(event.getDistance());
        accessoryModule.getAllAccessoryList().stream().map(accessory -> {
            FinnFall module;
            return accessory instanceof FinnFall ? (module = (FinnFall)((Object)accessory)) : null;
        }).filter(Objects::nonNull).sorted(Comparator.comparingInt(FinnFall::fallModificationPriority)).forEach(accessory -> accessory.fallDamageMultModifier(event.getDistance(), damageTransformer, distanceTransformer));
        event.setDamageMultiplier(damageTransformer.floatValue());
        event.setDistance(distanceTransformer.floatValue());
    }

    public static void livingJumpHook(LivingEvent.LivingJumpEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            BCMovementHooks.playerJumpHook(player, event);
        }
    }

    private static void playerJumpHook(Player player, LivingEvent.LivingJumpEvent event) {
        float f = player.m_146908_() * ((float)Math.PI / 180);
        float deltaFactor = BCEvaluations.EXTRA_JUMP_FORWARD.test(player).floatValue() / 10.0f;
        if (deltaFactor > 0.0f) {
            player.m_20256_(player.m_20184_().m_82520_((double)(-Mth.m_14031_((float)f) * deltaFactor), 0.0, (double)(Mth.m_14089_((float)f) * deltaFactor)));
        }
    }
}

