/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.hooks;

import bottomtextdanny.braincell.mod.capability.BCCapabilityHelper;
import bottomtextdanny.braincell.mod.capability.player.BCAccessoryModule;
import bottomtextdanny.braincell.mod.capability.player.accessory.extensions.CriticalStateMutable;
import bottomtextdanny.braincell.mod.capability.player.accessory.extensions.FinnHit;
import bottomtextdanny.braincell.mod.capability.player.accessory.extensions.FinnMakeMeleeCritical;
import bottomtextdanny.braincell.mod.capability.player.accessory.extensions.ForceCriticalDirectValue;
import bottomtextdanny.braincell.mod.world.entity_utilities.EntityHurtCallout;
import java.util.Comparator;
import java.util.Objects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableObject;

public final class BCAttackHooks {
    public static void damageLivingHook(LivingDamageEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BCAttackHooks.playerDamageHook(player, event);
        }
        if (event.getEntityLiving() instanceof EntityHurtCallout) {
            event.setAmount(((EntityHurtCallout)event.getEntityLiving()).hurtCallOut(event.getAmount(), event.getSource()));
        }
    }

    public static void playerDamageHook(Player player, LivingDamageEvent event) {
        if (player.m_6084_()) {
            BCAccessoryModule accessoryModule = BCCapabilityHelper.accessoryModule(player);
            MutableObject damageTransformer = new MutableObject((Object)Float.valueOf(event.getAmount()));
            DamageSource damageSource = event.getSource();
            if (damageSource instanceof IndirectEntityDamageSource) {
                IndirectEntityDamageSource source = (IndirectEntityDamageSource)damageSource;
                accessoryModule.getAllAccessoryList().stream().map(accessory -> {
                    FinnHit module;
                    return accessory instanceof FinnHit ? (module = (FinnHit)((Object)accessory)) : null;
                }).filter(Objects::nonNull).sorted(Comparator.comparingInt(FinnHit::hitModificationPriority)).forEach(accessory -> accessory.onIndirectAttack(event.getEntityLiving(), source, (MutableObject<Float>)damageTransformer, event.getAmount()));
                event.setAmount(((Float)damageTransformer.getValue()).floatValue());
            } else {
                accessoryModule.getAllAccessoryList().stream().map(accessory -> {
                    FinnHit module;
                    return accessory instanceof FinnHit ? (module = (FinnHit)((Object)accessory)) : null;
                }).filter(Objects::nonNull).sorted(Comparator.comparingInt(FinnHit::hitModificationPriority)).forEach(accessory -> accessory.onMeleeAttack(event.getEntityLiving(), event.getSource(), (MutableObject<Float>)damageTransformer, event.getAmount()));
                event.setAmount(((Float)damageTransformer.getValue()).floatValue());
            }
        }
    }

    public static void criticalHitHook(CriticalHitEvent event) {
        Entity entity;
        Player player = event.getPlayer();
        if (player.m_6084_() && (entity = event.getTarget()) instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)entity;
            BCAccessoryModule accessoryModule = BCCapabilityHelper.accessoryModule(player);
            MutableFloat chanceTransformer = new MutableFloat(0.0f);
            CriticalStateMutable directState = new CriticalStateMutable();
            accessoryModule.getAllAccessoryList().stream().map(accessory -> {
                FinnMakeMeleeCritical module;
                return accessory instanceof FinnMakeMeleeCritical ? (module = (FinnMakeMeleeCritical)((Object)accessory)) : null;
            }).filter(Objects::nonNull).sorted(Comparator.comparingInt(FinnMakeMeleeCritical::critMakingModulePriority)).forEach(accessory -> accessory.makeMeleeCritical(livingTarget, chanceTransformer, directState));
            if (directState.getState() != ForceCriticalDirectValue.STRICTLY_NOT_HAPPEN && (directState.getState() == ForceCriticalDirectValue.HAPPEN || directState.getState() == ForceCriticalDirectValue.STRICTLY_HAPPEN || player.m_21187_().nextFloat() < chanceTransformer.getValue().floatValue())) {
                event.setResult(Event.Result.ALLOW);
            }
            if (event.getResult() == Event.Result.ALLOW || event.isVanillaCritical() && event.getResult() == Event.Result.DEFAULT) {
                MutableObject damageTransformer = new MutableObject((Object)Float.valueOf(event.getDamageModifier()));
                accessoryModule.getAllAccessoryList().stream().map(accessory -> {
                    FinnHit module;
                    return accessory instanceof FinnHit ? (module = (FinnHit)((Object)accessory)) : null;
                }).filter(Objects::nonNull).sorted(Comparator.comparingInt(FinnHit::criticalModificationPriority)).forEach(accessory -> accessory.onMeleeCritical(livingTarget, (MutableObject<Float>)damageTransformer, event.getDamageModifier()));
                event.setDamageModifier(((Float)damageTransformer.getValue()).floatValue());
            }
        }
    }
}

