/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.gui;

import bottomtextdanny.braincell.base.screen.ImageData;
import bottomtextdanny.braincell.mod._base.blitty.Blitty;
import bottomtextdanny.braincell.mod.gui.EditableText;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.apache.commons.compress.utils.Lists;

public class ListingBox
extends EditableText {
    private static final ImageData BUTTONS_IMAGE = new ImageData("braincell", "textures/gui/screen/listing_box_buttons.png", 32, 32);
    private static final Blitty[] ARROW_UP = new Blitty[]{new Blitty(BUTTONS_IMAGE, 0, 0, 16, 8), new Blitty(BUTTONS_IMAGE, 0, 16, 16, 8)};
    private static final Blitty[] ARROW_DOWN = new Blitty[]{new Blitty(BUTTONS_IMAGE, 0, 8, 16, 8), new Blitty(BUTTONS_IMAGE, 0, 24, 16, 8)};
    private static final Blitty[] DELETE = new Blitty[]{new Blitty(BUTTONS_IMAGE, 16, 0, 16, 16), new Blitty(BUTTONS_IMAGE, 16, 16, 16, 16)};
    private static int LIST_Y_OFFSET = 16;
    private static int ENTRY_HEIGHT = 16;
    private static int ENTRY_HEIGHT_DIV2 = ENTRY_HEIGHT / 2;
    private static int MAX_DISPLAY_ENTRIES = 5;
    private static int ENTRIES_HEIGHT = ENTRY_HEIGHT * MAX_DISPLAY_ENTRIES;
    private static int ENTRY_CONTROLLERS_WIDTH = 16;
    private static int BORDER_WIDTH = 1;
    private static int ENTRY_SPACING = 2;
    private List<String> contents;
    @Nullable
    private final Set<String> entriesSet;
    private Predicate<String> validator;
    private int contentDisplayOffset;
    private int listBackgroundColor;
    private int entryBackgroundColor;
    private int entryColor;

    public ListingBox(Font font, int x, int y, int width, Component message, boolean allowsDuplicates) {
        super(font, x, y, width, message);
        this.setValidator(s -> true);
        this.contents = Lists.newArrayList();
        this.entriesSet = allowsDuplicates ? null : Sets.newHashSet();
        this.listBackgroundColor = -16777216;
        this.entryBackgroundColor = -14671840;
        this.entryColor = -1;
    }

    @Override
    public void m_6305_(PoseStack pose, int x, int y, float tickOffset) {
        super.m_6305_(pose, x, y, tickOffset);
        if (!this.isSelected()) {
            return;
        }
        int listSize = this.contents.size();
        int listY = this.listY();
        int entryX = this.f_93620_ + BORDER_WIDTH;
        int entryWidth = this.f_93618_ - ENTRY_CONTROLLERS_WIDTH * 2 - BORDER_WIDTH * 2;
        int firstIndex = this.fistVisibleIndex();
        int displayLength = listSize - firstIndex;
        int displayListLength = Math.min(displayLength, MAX_DISPLAY_ENTRIES);
        int backgroundHeight = Mth.m_14045_((int)displayListLength, (int)1, (int)MAX_DISPLAY_ENTRIES) * ENTRY_HEIGHT + BORDER_WIDTH * 2;
        ListingBox.m_93172_((PoseStack)pose, (int)this.f_93620_, (int)listY, (int)(this.f_93620_ + this.f_93618_), (int)(listY + backgroundHeight), (int)this.getBorderColor());
        ListingBox.m_93172_((PoseStack)pose, (int)(this.f_93620_ + 1), (int)(listY + 1), (int)(this.f_93620_ + this.f_93618_ - 1), (int)(listY + backgroundHeight - 1), (int)this.listBackgroundColor);
        Objects.requireNonNull(this.font());
        int lineHeightDiv2 = 9 / 2;
        int localOffsetY = BORDER_WIDTH;
        if (displayListLength == 0) {
            String entryMessage = "<no entries>";
            entryMessage = this.font().m_92834_(entryMessage, entryWidth - ENTRY_SPACING * 2);
            this.font().m_92750_(pose, entryMessage, (float)(entryX + ENTRY_SPACING), (float)(listY + localOffsetY + ENTRY_HEIGHT_DIV2 - lineHeightDiv2), this.entryColor);
            return;
        }
        for (int i = 0; i < displayListLength; ++i) {
            Blitty up = ARROW_UP[0];
            Blitty down = ARROW_DOWN[0];
            Blitty delete = DELETE[0];
            int entryY = listY + localOffsetY;
            ListingBox.m_93172_((PoseStack)pose, (int)entryX, (int)entryY, (int)(entryX + entryWidth), (int)(entryY + ENTRY_HEIGHT), (int)-16777216);
            ListingBox.m_93172_((PoseStack)pose, (int)(entryX + 1), (int)(entryY + 1), (int)(entryX + entryWidth - 1), (int)(entryY + ENTRY_HEIGHT - 1), (int)this.entryBackgroundColor);
            int localX = x - this.f_93620_;
            int localY = y - entryY;
            if (x >= this.f_93620_ && x < this.f_93620_ + this.f_93618_ && y >= entryY && y < entryY + ENTRY_HEIGHT) {
                if (this.touchesEntryUp(localX, localY)) {
                    up = ARROW_UP[1];
                } else if (this.touchesEntryDown(localX, localY)) {
                    down = ARROW_DOWN[1];
                } else if (this.touchesEntryDelete(localX, localY)) {
                    delete = DELETE[1];
                }
            }
            BUTTONS_IMAGE.use();
            up.render(pose, entryX + entryWidth, entryY, 0.0f);
            down.render(pose, entryX + entryWidth, entryY + ENTRY_HEIGHT_DIV2, 0.0f);
            delete.render(pose, entryX + entryWidth + ENTRY_CONTROLLERS_WIDTH, entryY, 0.0f);
            String entryMessage = this.contents.get(firstIndex + i);
            entryMessage = this.font().m_92834_(entryMessage, entryWidth - ENTRY_SPACING * 2);
            this.font().m_92750_(pose, entryMessage, (float)(entryX + ENTRY_SPACING), (float)(entryY + ENTRY_HEIGHT_DIV2 - lineHeightDiv2), this.entryColor);
            localOffsetY += ENTRY_HEIGHT;
        }
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isSelected()) {
            int offset;
            int index;
            int contentsY = this.listY();
            if (mouseX >= (double)this.f_93620_ && mouseX < (double)(this.f_93620_ + this.f_93618_) && mouseY >= (double)contentsY && mouseY < (double)(contentsY + ENTRIES_HEIGHT) && (index = (offset = (int)((mouseY - (double)contentsY) % (double)ENTRY_HEIGHT)) + this.fistVisibleIndex()) < this.contents.size()) {
                int localX = (int)mouseX - this.f_93620_;
                int localY = ((int)mouseY - contentsY) % ENTRY_HEIGHT;
                SoundManager m = Minecraft.m_91087_().m_91106_();
                if (this.touchesEntryDelete(localX, localY)) {
                    if (this.tryDeleteEntry(index)) {
                        this.m_7435_(m);
                    }
                } else if (this.touchesEntryUp(localX, localY)) {
                    if (this.tryMoveEntryUp(index)) {
                        this.m_7435_(m);
                    }
                } else if (this.touchesEntryDown(localX, localY) && this.tryMoveEntryDown(index)) {
                    this.m_7435_(m);
                }
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double step) {
        int contentsY = this.listY();
        if (mouseX >= (double)this.f_93620_ && mouseX < (double)(this.f_93620_ + this.f_93618_) && mouseY >= (double)contentsY && mouseY < (double)(contentsY + ENTRIES_HEIGHT)) {
            this.setContentDisplayOffset(this.contentDisplayOffset - (int)step);
        }
        return super.m_6050_(mouseX, mouseY, step);
    }

    @Override
    public boolean m_7933_(int key, int p_94746_, int p_94747_) {
        if ((key == 257 || key == 335) && this.validator.test(this.getCurrentText())) {
            this.addEntry(this.getCurrentText());
            return true;
        }
        return super.m_7933_(key, p_94746_, p_94747_);
    }

    public boolean tryDeleteEntry(int index) {
        if (index >= 0 && index < this.contents.size()) {
            if (!this.allowsDuplicates()) {
                this.entriesSet.remove(this.contents.get(index));
            }
            this.contents.remove(index);
            return true;
        }
        return false;
    }

    public boolean tryMoveEntryUp(int index) {
        if (index >= 1 && index < this.contents.size()) {
            String temp = this.contents.get(index - 1);
            this.contents.set(index - 1, this.contents.get(index));
            this.contents.set(index, temp);
            return true;
        }
        return false;
    }

    public boolean tryMoveEntryDown(int index) {
        if (index >= 0 && index < this.contents.size() - 1) {
            String temp = this.contents.get(index + 1);
            this.contents.set(index + 1, this.contents.get(index));
            this.contents.set(index, temp);
            return true;
        }
        return false;
    }

    public void addEntry(String string) {
        if (!this.allowsDuplicates()) {
            if (!this.entriesSet.contains(string)) {
                this.entriesSet.add(string);
                this.contents.add(string);
            }
        } else {
            this.contents.add(string);
        }
    }

    public void setNewContents(List<String> contents) {
        this.contents = contents;
        if (!this.allowsDuplicates()) {
            this.entriesSet.clear();
            List<String> strings = this.contents;
            for (int i = 0; i < strings.size(); ++i) {
                String c = strings.get(i);
                if (this.entriesSet.contains(c)) {
                    this.contents.remove(i);
                    --i;
                    continue;
                }
                this.entriesSet.add(c);
            }
        }
    }

    public void setValidator(Predicate<String> validator) {
        this.validator = validator;
    }

    public void setContentDisplayOffset(int value) {
        this.contentDisplayOffset = Math.max(0, Math.min(value, this.contents.size() - MAX_DISPLAY_ENTRIES));
    }

    public void setListBackgroundColor(int listBackgroundColor) {
        this.listBackgroundColor = listBackgroundColor;
    }

    public void setEntryBackgroundColor(int entryBackgroundColor) {
        this.entryBackgroundColor = entryBackgroundColor;
    }

    public void setEntryColor(int entryColor) {
        this.entryColor = entryColor;
    }

    public List<String> getContents() {
        return this.contents;
    }

    private boolean touchesEntryDelete(int localX, int localY) {
        return localX >= this.f_93618_ - ENTRY_CONTROLLERS_WIDTH;
    }

    private boolean touchesEntryUp(int localX, int localY) {
        return localX >= this.f_93618_ - ENTRY_CONTROLLERS_WIDTH * 2 && localX < this.f_93618_ - ENTRY_CONTROLLERS_WIDTH && localY < ENTRY_CONTROLLERS_WIDTH / 2;
    }

    private boolean touchesEntryDown(int localX, int localY) {
        return localX >= this.f_93618_ - ENTRY_CONTROLLERS_WIDTH * 2 && localX < this.f_93618_ - ENTRY_CONTROLLERS_WIDTH && localY >= ENTRY_CONTROLLERS_WIDTH / 2;
    }

    private int listY() {
        return this.f_93621_ + 15;
    }

    private int fistVisibleIndex() {
        return this.contentDisplayOffset;
    }

    public boolean isDuplicate(String string) {
        return !this.allowsDuplicates() && this.entriesSet.contains(string);
    }

    public boolean allowsDuplicates() {
        return this.entriesSet == null;
    }
}

