/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.gui;

import bottomtextdanny.braincell.base.BCCharacterUtil;
import bottomtextdanny.braincell.mod.gui.BCSelectable;
import bottomtextdanny.braincell.mod.gui.BCSelector;
import bottomtextdanny.braincell.mod.gui.TickableComponent;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;

public class EditableText
extends AbstractWidget
implements BCSelectable,
TickableComponent {
    private Function<String, String> textProcessor = Function.identity();
    private Predicate<Character> wordSeparator;
    private Function<String, Integer> colorProcessor;
    private Consumer<String> onTextModification;
    private BiConsumer<String, Integer> keyActor = (text, keyCode) -> {};
    private final Font font;
    private final int underscoreSpace;
    private BCSelector selector;
    private String currentText;
    private int tickCounter;
    private int borderColor;
    private int unfocusedBorderColor;
    private int offset;
    private int highlight;
    private int pointer;

    public EditableText(Font font, int x, int y, int width, Component message) {
        super(x, y, width, 16, message);
        this.font = font;
        this.currentText = "";
        this.setColorProcessor(text -> -1);
        this.setWordSeparator(BCCharacterUtil.wordSeparator());
        this.underscoreSpace = this.font.m_92895_("_");
        this.onTextModification = text -> {};
    }

    public void m_6305_(PoseStack pose, int x, int y, float tickOffset) {
        super.m_6305_(pose, x, y, tickOffset);
    }

    @Override
    public void tick() {
        ++this.tickCounter;
    }

    public void m_6303_(PoseStack pose, int x, int y, float tickOffset) {
        boolean selected = this.isSelected();
        boolean highlighting = this.highlightActive();
        boolean showMarker = selected && Math.abs(this.tickCounter % 10) <= 5;
        String pointerMarker = "|";
        int borderColor = selected ? this.borderColor : this.unfocusedBorderColor;
        int maxLength = this.getMaxShowLength();
        String offsetText = this.currentText.substring(this.offset);
        String displayedText = this.font.m_92834_(offsetText, maxLength);
        int pointerDisplayIndex = Math.max(0, this.pointer - this.offset);
        int pointerX = this.font.m_92895_(offsetText.substring(0, pointerDisplayIndex));
        int clampedPointerX = Math.min(pointerX, maxLength);
        EditableText.m_93172_((PoseStack)pose, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)borderColor);
        EditableText.m_93172_((PoseStack)pose, (int)(this.f_93620_ + 1), (int)(this.f_93621_ + 1), (int)(this.f_93620_ + this.f_93618_ - 1), (int)(this.f_93621_ + this.f_93619_ - 1), (int)-16777216);
        if (highlighting) {
            int highlightDisplayIndex = Math.max(0, this.highlight - this.offset);
            int highlightX = Math.min(this.font.m_92895_(offsetText.substring(0, highlightDisplayIndex)), maxLength);
            int min = Math.min(pointerX, highlightX);
            int max = Math.max(pointerX, highlightX);
            EditableText.m_93172_((PoseStack)pose, (int)(this.f_93620_ + min + 2), (int)(this.f_93621_ + 3), (int)(this.f_93620_ + max + 3), (int)(this.f_93621_ + 13), (int)-2147475201);
        }
        if (!displayedText.isEmpty()) {
            this.font.m_92750_(pose, displayedText, (float)(this.f_93620_ + 3), (float)(this.f_93621_ + 4), -1);
        } else {
            String ghostText = this.font.m_92834_(this.m_6035_().getString(), maxLength);
            this.font.m_92750_(pose, ghostText, (float)(this.f_93620_ + 3), (float)(this.f_93621_ + 4), -10461088);
        }
        if (!highlighting && this.pointer == this.currentText.length() && maxLength - pointerX >= this.underscoreSpace) {
            pointerMarker = "_";
        }
        if (showMarker) {
            this.font.m_92750_(pose, pointerMarker, (float)(this.f_93620_ + clampedPointerX + 2), (float)(this.f_93621_ + 4), -1);
        }
    }

    public void m_142291_(NarrationElementOutput out) {
        out.m_169146_(NarratedElementType.TITLE, (Component)new TranslatableComponent("narration.edit_box", new Object[]{this.currentText}));
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isSelected() && this.inbounds(mouseX, mouseY)) {
            int lx = (int)mouseX - this.f_93620_;
            String offsetString = this.getOffsetString();
            this.setPointer(this.font.m_92834_(offsetString, lx).length());
            return true;
        }
        return false;
    }

    public boolean m_7933_(int key, int p_94746_, int p_94747_) {
        if (!this.isSelected()) {
            return false;
        }
        this.runKeyActor(key);
        boolean shiftDown = Screen.m_96638_();
        boolean controlDown = Screen.m_96637_();
        if (Screen.m_96634_((int)key)) {
            this.setPointer(this.currentText.length());
            this.setHighlight(0);
            return true;
        }
        if (Screen.m_96632_((int)key) && this.highlightActive()) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.getHighlighted());
            return true;
        }
        if (Screen.m_96630_((int)key)) {
            this.insertText(this.pointer, Minecraft.m_91087_().f_91068_.m_90876_());
            return true;
        }
        if (Screen.m_96628_((int)key) && this.highlightActive()) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.getHighlighted());
            this.setCurrentText("");
            return true;
        }
        switch (key) {
            case 259: {
                if (controlDown) {
                    this.deleteTextByIndices(this.getNextWordIndex(this.pointer, true), this.pointer);
                } else if (this.highlightActive()) {
                    int min = Math.min(this.pointer, this.highlight);
                    int max = Math.max(this.pointer, this.highlight);
                    this.deleteTextByIndices(min, max);
                } else {
                    this.deleteText(this.pointer, 1, true);
                }
                return true;
            }
            case 260: 
            case 261: 
            case 264: 
            case 265: 
            case 266: 
            case 267: {
                if (controlDown) {
                    this.deleteTextByIndices(this.pointer, this.getNextWordIndex(this.pointer, false));
                } else if (this.highlightActive()) {
                    int min = Math.min(this.pointer, this.highlight);
                    int max = Math.max(this.pointer, this.highlight);
                    this.deleteTextByIndices(min, max);
                } else {
                    this.deleteText(this.pointer, 1, false);
                }
                return true;
            }
            case 262: {
                int oldHighlight = this.highlight;
                if (controlDown) {
                    if (shiftDown) {
                        this.setPointer(this.getNextWordIndex(this.pointer, false), false);
                        this.setHighlight(oldHighlight);
                    } else {
                        this.setPointer(this.getNextWordIndex(this.pointer, false), true);
                    }
                } else if (shiftDown) {
                    this.setPointer(this.pointer + 1, false);
                    this.setHighlight(oldHighlight);
                } else {
                    this.setPointer(Math.max(this.highlight, this.pointer + 1), true);
                }
                return true;
            }
            case 263: {
                int oldHighlight = this.highlight;
                if (controlDown) {
                    if (shiftDown) {
                        this.setPointer(this.getNextWordIndex(this.pointer, true), false);
                        this.setHighlight(oldHighlight);
                    } else {
                        this.setPointer(this.getNextWordIndex(this.pointer, true), true);
                    }
                } else if (shiftDown) {
                    this.setPointer(this.pointer - 1, false);
                    this.setHighlight(oldHighlight);
                } else {
                    this.setPointer(Math.min(this.highlight, this.pointer - 1), true);
                }
                return true;
            }
            case 268: {
                this.setPointer(0);
                return true;
            }
            case 269: {
                this.setPointer(this.currentText.length());
                return true;
            }
        }
        return false;
    }

    public void runKeyActor(int key) {
        this.keyActor.accept(this.currentText, key);
    }

    public void runOnTextModification() {
        this.onTextModification.accept(this.currentText);
    }

    public boolean m_5534_(char character, int modifiers) {
        if (SharedConstants.m_136188_((char)character)) {
            this.insertText(this.pointer, Character.toString(character));
            return true;
        }
        return false;
    }

    private void insertText(int at, String text) {
        if (text != null && !text.isEmpty() && at <= this.currentText.length()) {
            boolean movePointer = this.pointer >= at;
            String offsetBackwards = this.currentText.substring(0, at);
            String offsetForward = this.currentText.substring(at);
            String rawNewText = offsetBackwards + text + offsetForward;
            this.setCurrentText(this.textProcessor.apply(rawNewText));
            if (movePointer) {
                this.setPointer(this.pointer + text.length());
            }
        }
    }

    private void deleteText(int at, int characters, boolean backwards) {
        if (!this.currentText.isEmpty() && at <= this.currentText.length()) {
            int deletionEnd;
            int deletionStart;
            boolean movePointer;
            boolean bl = movePointer = this.pointer >= at;
            if (backwards) {
                deletionStart = Math.max(0, at - characters);
                deletionEnd = at;
            } else {
                deletionStart = at;
                deletionEnd = Math.min(this.currentText.length(), at + characters);
            }
            this.setCurrentText(this.currentText.substring(0, deletionStart) + this.currentText.substring(deletionEnd));
            if (movePointer) {
                this.setPointer(deletionStart);
            }
        }
    }

    private void deleteTextByIndices(int start, int end) {
        if (!this.currentText.isEmpty() && end <= this.currentText.length()) {
            boolean movePointer = this.pointer >= start;
            this.setCurrentText(this.currentText.substring(0, start) + this.currentText.substring(end));
            if (movePointer) {
                this.setPointer(start);
            }
        }
    }

    private void checkOffset() {
        int maxLength = this.getMaxShowLength();
        int lPointer = Mth.m_14045_((int)(this.pointer - 1), (int)0, (int)this.currentText.length());
        if (lPointer < this.offset) {
            String textToPointer = this.currentText.substring(0, lPointer);
            String reverseFromPointer = new StringBuffer(textToPointer).reverse().toString();
            int cutoff = this.font.m_92834_(reverseFromPointer, maxLength).length();
            this.setOffset(textToPointer.length() - cutoff);
        } else {
            String offsetText = this.currentText.substring(this.offset, this.pointer);
            int xLength = this.font.m_92895_(offsetText);
            if (xLength > maxLength) {
                String cutText = this.font.m_92834_(offsetText, maxLength);
                int cutoff = offsetText.length() - cutText.length();
                this.setOffset(this.offset + cutoff);
            }
        }
    }

    public void updateColor() {
        this.borderColor = this.colorProcessor.apply(this.currentText);
        int a = this.borderColor >> 24 & 0xFF;
        int r = (this.borderColor >> 16 & 0xFF) / 2;
        int g = (this.borderColor >> 8 & 0xFF) / 2;
        int b = (this.borderColor & 0xFF) / 2;
        this.unfocusedBorderColor = (a << 24) + (r << 16) + (g << 8) + b;
    }

    @Override
    public boolean shouldBeSelected(int x, int y) {
        return this.inbounds(x, y);
    }

    @Override
    public void onSelection() {
        this.m_7435_(Minecraft.m_91087_().m_91106_());
    }

    public void setCurrentText(String currentText) {
        this.currentText = currentText;
        if (this.pointer > this.currentText.length()) {
            this.setPointer(this.currentText.length());
        }
        this.setHighlight(this.pointer);
        this.checkOffset();
        this.runOnTextModification();
        this.updateColor();
    }

    public void setTextProcessor(Function<String, String> textProcessor) {
        this.textProcessor = textProcessor;
    }

    public void setKeyActor(BiConsumer<String, Integer> keyActor) {
        this.keyActor = keyActor;
    }

    public void setWordSeparator(Predicate<Character> wordSeparator) {
        this.wordSeparator = wordSeparator;
    }

    public void setColorProcessor(Function<String, Integer> colorProcessor) {
        this.colorProcessor = colorProcessor;
        this.updateColor();
    }

    public void onTextModification(Consumer<String> onTextModification) {
        this.onTextModification = onTextModification;
    }

    protected void setPointer(int pointer) {
        this.setPointer(pointer, true);
    }

    protected void setPointer(int pointer, boolean resetHighlight) {
        this.pointer = Math.max(0, Math.min(pointer, this.currentText.length()));
        if (resetHighlight) {
            this.highlight = this.pointer;
        }
        this.checkOffset();
    }

    protected void setOffset(int offset) {
        this.offset = Math.max(0, Math.min(offset, this.currentText.length()));
    }

    protected void setHighlight(int highlight) {
        this.highlight = Math.max(0, Math.min(highlight, this.currentText.length()));
    }

    @Override
    public void attachToSelector(BCSelector selector) {
        this.selector = selector;
    }

    public String getOffsetString() {
        return this.currentText.substring(Math.min(this.offset, this.currentText.length()));
    }

    public String getCurrentText() {
        return this.currentText;
    }

    public String getHighlighted() {
        if (this.highlightActive()) {
            int min = Math.min(this.highlight, this.pointer);
            int max = Math.max(this.highlight, this.pointer);
            return this.currentText.substring(min, max);
        }
        return null;
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    protected int getNextWordIndex(int from, boolean backwards) {
        int i;
        from = Mth.m_14045_((int)from, (int)0, (int)(this.currentText.length() - 1));
        char[] arr = this.currentText.toCharArray();
        if (backwards) {
            for (i = from; i == from || i > 0 && !this.wordSeparator.test(Character.valueOf(arr[i - 1])); --i) {
            }
        } else {
            for (i = from; i == from || i < arr.length && !this.wordSeparator.test(Character.valueOf(arr[i - 1])); ++i) {
            }
        }
        return Mth.m_14045_((int)i, (int)0, (int)arr.length);
    }

    @Override
    public BCSelector selector() {
        return this.selector;
    }

    protected Font font() {
        return this.font;
    }

    private int getMaxShowLength() {
        return Math.max(this.f_93618_ - 6, 0);
    }

    private boolean highlightActive() {
        return this.highlight != this.pointer;
    }

    public boolean inbounds(double x, double y) {
        return x >= (double)this.f_93620_ && x < (double)(this.f_93620_ + this.f_93618_) && y >= (double)this.f_93621_ && y < (double)(this.f_93621_ + this.f_93619_);
    }
}

