/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.graphics.screen_tonemapping;

import bottomtextdanny.braincell.mod.graphics.screen_tonemapping.TonemapAgent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class TransientTonemapAgent
extends TonemapAgent {
    public final int lifetime;
    private int lifeTicks;

    public TransientTonemapAgent(int lifetime) {
        this.lifetime = lifetime;
    }

    @Override
    public void tick() {
        ++this.lifeTicks;
    }

    @Override
    public boolean removeIf() {
        return this.lifeTicks >= this.lifetime;
    }

    public int getLifeTicks() {
        return this.lifeTicks;
    }

    public static TransientTonemapAgent createBlink(int lifetime) {
        return new BlinkTonemapAgent(lifetime);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class BlinkTonemapAgent
    extends TransientTonemapAgent {
        public BlinkTonemapAgent(int lifetime) {
            super(lifetime);
        }

        @Override
        public void render(float partialTick) {
            float blackness = -(((float)this.lifetime - ((float)this.getLifeTicks() + partialTick)) / (float)this.lifetime) * 0.8f;
            this.getChannelModifier().m_122245_(blackness, blackness, blackness);
        }
    }
}

