/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.graphics.screen_tonemapping;

import bottomtextdanny.braincell.Braincell;
import bottomtextdanny.braincell.mod._base.BCStaticData;
import bottomtextdanny.braincell.mod._base.opengl.ShaderWorkflow;
import bottomtextdanny.braincell.mod.graphics.screen_tonemapping.TonemapAgent;
import bottomtextdanny.braincell.mod.graphics.screen_tonemapping.TonemapperPixelProgram;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TonemapWorkflow
extends ShaderWorkflow {
    private final TonemapperPixelProgram tonemapperProgram = new TonemapperPixelProgram(this);
    private final ConcurrentLinkedDeque<TonemapAgent> agents = new ConcurrentLinkedDeque();
    private float outDesaturation;
    private Vector3f outChannelMultiplier = new Vector3f();

    @Override
    protected void execute() {
        Vector4f agentOutput = this.getAgentOutput();
        this.outChannelMultiplier = new Vector3f(agentOutput.m_123601_(), agentOutput.m_123615_(), agentOutput.m_123616_());
        this.outDesaturation = agentOutput.m_123617_();
        this.tonemapperProgram.flow();
    }

    @Override
    protected void tick() {
        if (this.agents.isEmpty()) {
            return;
        }
        if (!Minecraft.m_91087_().m_91104_()) {
            this.agents.removeIf(agent -> {
                agent.tick();
                return agent.removeIf();
            });
        }
    }

    private Vector4f getAgentOutput() {
        Vector4f output = new Vector4f();
        for (TonemapAgent agent : this.agents) {
            agent.render(BCStaticData.partialTick());
            output.m_176875_(agent.getChannelModifier().m_122239_(), agent.getChannelModifier().m_122260_(), agent.getChannelModifier().m_122269_(), agent.getSaturationModifier());
        }
        return output;
    }

    public float getOutDesaturation() {
        return this.outDesaturation;
    }

    public Vector3f getOutChannelMultiplier() {
        return this.outChannelMultiplier;
    }

    public boolean addAgent(TonemapAgent agent) {
        if (!this.invalidated && this.shouldApply() && agent != null) {
            return this.agents.add(agent);
        }
        return false;
    }

    @Override
    protected boolean shouldApply() {
        return TonemapWorkflow.MC.f_91074_ != null && Braincell.client().config().screenTonemapping();
    }
}

