/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.graphics.point_lighting;

import bottomtextdanny.braincell.Braincell;
import bottomtextdanny.braincell.base.BCMath;
import bottomtextdanny.braincell.base.pair.Pair;
import bottomtextdanny.braincell.mod._base.opengl.PixelProgram;
import bottomtextdanny.braincell.mod._base.opengl.UniformManager;
import bottomtextdanny.braincell.mod._base.opengl.enums.ShaderType;
import bottomtextdanny.braincell.mod._mod.client_sided.BraincellClientConfig;
import bottomtextdanny.braincell.mod.graphics.point_lighting.IPointLight;
import bottomtextdanny.braincell.mod.graphics.point_lighting.PointLightingWorkflow;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL15;

@OnlyIn(value=Dist.CLIENT)
public class PointLightingPixelProgram
extends PixelProgram<PointLightingWorkflow> {
    public static final int COLOR_POINTER = 0;
    public static final int BRIGHTNESS_LIGHTUP_POINTER = 1;
    public static final int POSITION_RADIUS_POINTER = 2;
    private final List<? extends IPointLight> lightList;

    public PointLightingPixelProgram(PointLightingWorkflow workflow, List<? extends IPointLight> lightList) {
        super(workflow, new ResourceLocation("braincell", "point_lighting"));
        this.lightList = lightList;
    }

    @Override
    public UniformManager createUniformManager() {
        return new UniformManager(this, Pair.of("lights[].color", 256), Pair.of("lights[].brightness_lightup", 256), Pair.of("lights[].position_rad", 256));
    }

    @Override
    protected String[] getSourceTransformers(ShaderType type) {
        if (type == ShaderType.FRAGMENT) {
            BraincellClientConfig config = Braincell.client().config();
            int xTileDiv = BCMath.roundUp(config.xTileDivisions(), 4);
            int yTileDiv = BCMath.roundUp(config.yTileDivisions(), 4);
            return new String[]{"&xgrid", String.valueOf(xTileDiv), "&ygrid", String.valueOf(yTileDiv), "&g_square", String.valueOf(xTileDiv * yTileDiv), "&max_lights", String.valueOf(BCMath.roundUp(config.maxLights(), 4)), "&region_lights", String.valueOf(BCMath.roundUp(config.maxLightsPerTile(), 4)), "&debug", ""};
        }
        return super.getSourceTransformers(type);
    }

    @Override
    protected void renderSpace() {
        int lightAmount = ((PointLightingWorkflow)this.workflow).lightsRendered();
        this.bindBuffer(((PointLightingWorkflow)this.workflow).tileInformationBlock);
        this.uTextureBinding("diffuse", PointLightingPixelProgram.mainTarget().m_83975_());
        this.uTextureBinding("depth", Braincell.client().getRenderingHandler().getWorldDepthFramebuffer().getDepthID());
        this.uTextureBinding("debug", ((PointLightingWorkflow)this.workflow).debugBuffer.getId());
        this.uMatrix("inv_model_view", Braincell.client().getRenderingHandler().getInvertedModelViewMatrix());
        this.uFloat("fog_start", Braincell.client().getRenderingHandler().getTerrainFogStart() - 5.0f);
        this.uFloat("fog_end", Braincell.client().getRenderingHandler().getTerrainFogEnd() - 5.0f);
        this.uVector4("fog_color", Braincell.client().getRenderingHandler().getTerrainFogColor());
        for (int i = 0; i < lightAmount; ++i) {
            IPointLight light = this.lightList.get(i);
            this.uVector2(this.uniformManager.retrieveLocations(1)[i], light.brightness(), light.lightupFactor());
            this.uVector3(this.uniformManager.retrieveLocations(0)[i], light.color());
            this.uVector4(this.uniformManager.retrieveLocations(2)[i], light.position().m_82546_(PointLightingPixelProgram.mc().f_91063_.m_109153_().m_90583_()), light.radius());
        }
        PointLightingPixelProgram.renderScreenQuad();
        GL15.glBindBuffer((int)37074, (int)0);
    }
}

