/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.graphics.point_lighting;

import bottomtextdanny.braincell.Braincell;
import bottomtextdanny.braincell.base.BCMath;
import bottomtextdanny.braincell.base.pair.Pair;
import bottomtextdanny.braincell.mod._base.opengl.ComputationProgram;
import bottomtextdanny.braincell.mod._base.opengl.UniformManager;
import bottomtextdanny.braincell.mod._base.opengl.enums.ShaderType;
import bottomtextdanny.braincell.mod._mod.client_sided.BraincellClientConfig;
import bottomtextdanny.braincell.mod.graphics.point_lighting.IPointLight;
import bottomtextdanny.braincell.mod.graphics.point_lighting.PointLightingWorkflow;
import com.mojang.math.Matrix4f;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL15;

@OnlyIn(value=Dist.CLIENT)
public class PointLightingCompProgram
extends ComputationProgram<PointLightingWorkflow> {
    public static final int POSITION_RADIUS_POINTER = 0;
    private final List<? extends IPointLight> lightList;

    public PointLightingCompProgram(PointLightingWorkflow workflow, List<? extends IPointLight> lightList) {
        super(24, 16, 1, workflow, new ResourceLocation("braincell", "point_lighting"));
        this.lightList = lightList;
    }

    @Override
    public UniformManager createUniformManager() {
        return new UniformManager(this, Pair.of("lights[].position_rad", 256));
    }

    @Override
    protected String[] getSourceTransformers(ShaderType type) {
        if (type == ShaderType.COMPUTATION) {
            BraincellClientConfig config = Braincell.client().config();
            int xTileDiv = BCMath.roundUp(config.xTileDivisions(), 4);
            int yTileDiv = BCMath.roundUp(config.yTileDivisions(), 4);
            return new String[]{"&xgrid", String.valueOf(xTileDiv), "&ygrid", String.valueOf(yTileDiv), "&x1ingrid", String.valueOf(1.0f / (float)xTileDiv), "&y1ingrid", String.valueOf(1.0f / (float)yTileDiv), "&xhalf", String.valueOf((float)xTileDiv / 2.0f), "&yhalf", String.valueOf((float)yTileDiv / 2.0f), "&g_square", String.valueOf(xTileDiv * yTileDiv), "&max_lights", String.valueOf(BCMath.roundUp(config.maxLights(), 4)), "&region_lights", String.valueOf(BCMath.roundUp(config.maxLightsPerTile(), 4)), "&debugt", "", "&debugf", ""};
        }
        return super.getSourceTransformers(type);
    }

    @Override
    protected void renderSpace() {
        int lightAmount = ((PointLightingWorkflow)this.workflow).lightsRendered();
        Matrix4f projection = Braincell.client().getRenderingHandler().getProjectionMatrix().m_27658_();
        Matrix4f projMatInv = projection.m_27658_();
        projMatInv.m_27657_();
        Matrix4f view = Braincell.client().getRenderingHandler().getModelViewMatrix();
        this.bindBuffer(((PointLightingWorkflow)this.workflow).tileInformationBlock);
        ((PointLightingWorkflow)this.workflow).tileInformationBlock.resetData();
        this.uTextureBinding("depth", Braincell.client().getRenderingHandler().getWorldDepthFramebuffer().getDepthID());
        ((PointLightingWorkflow)this.workflow).debugBuffer.bind(2);
        this.uInteger("light_count", lightAmount);
        this.uMatrix("view", view);
        this.uMatrix("inv_proj", projMatInv);
        this.uMatrix("proj", projection);
        for (int i = 0; i < lightAmount; ++i) {
            IPointLight light = this.lightList.get(i);
            this.uVector4(this.uniformManager.retrieveLocations(0)[i], light.position().m_82546_(PointLightingCompProgram.mc().f_91063_.m_109153_().m_90583_()), light.radius());
        }
        this.dispatchProgram();
        GL15.glBindBuffer((int)37074, (int)0);
    }
}

