/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.entity.serialization;

import bottomtextdanny.braincell.mod._base.serialization.SerializerMark;
import bottomtextdanny.braincell.mod.entity.serialization.EntityDataReference;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;

public final class RawEntityDataReference<T> {
    private final SerializerMark<T> serializer;
    private final Supplier<T> defaultProvider;
    private final String storageKey;

    private RawEntityDataReference(SerializerMark<T> serializer, Supplier<T> defaultProvider, String storageKey) {
        this.serializer = serializer;
        this.defaultProvider = defaultProvider;
        this.storageKey = storageKey;
    }

    public static <T> RawEntityDataReference<T> of(SerializerMark<T> serializer, Supplier<T> defaultProvider, String storageKey) {
        return new RawEntityDataReference<T>(serializer, defaultProvider, storageKey);
    }

    public EntityDataReference<T> mark(Class<? extends Entity> accessor, int lookupMark) {
        return new EntityDataReference<T>(this.serializer, this.defaultProvider, this.storageKey, accessor, lookupMark);
    }

    public SerializerMark<T> serializer() {
        return this.serializer;
    }

    public Supplier<T> defaultProvider() {
        return this.defaultProvider;
    }

    public String storageKey() {
        return this.storageKey;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RawEntityDataReference that = (RawEntityDataReference)obj;
        return Objects.equals(this.serializer, that.serializer) && Objects.equals(this.defaultProvider, that.defaultProvider) && Objects.equals(this.storageKey, that.storageKey);
    }

    public int hashCode() {
        return Objects.hash(this.serializer, this.defaultProvider, this.storageKey);
    }

    public String toString() {
        return "RawDataReference[reference=" + this.serializer + ", defaultProvider=" + this.defaultProvider + ", storageKey=" + this.storageKey + "]";
    }
}

