/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.entity.serialization;

import bottomtextdanny.braincell.mod._base.serialization.EntityDataSerializer;
import bottomtextdanny.braincell.mod._base.serialization.SerializerMark;
import bottomtextdanny.braincell.mod._base.serialization.SimpleSerializer;
import bottomtextdanny.braincell.mod._base.serialization.WorldDataSerializer;
import bottomtextdanny.braincell.mod.entity.serialization.EntityDataReference;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;

public class EntityData<T> {
    private final EntityDataReference<T> reference;
    private T objInstance;

    public EntityData(EntityDataReference<T> reference) {
        this.reference = reference;
        this.objInstance = reference.defaultProvider().get();
    }

    public static <E> EntityData<E> of(EntityDataReference<E> reference) {
        return new EntityData<E>(reference);
    }

    public T get() {
        return this.objInstance;
    }

    public void set(T t) {
        this.objInstance = t;
    }

    public SerializerMark<T> getSerializer() {
        return this.reference.serializer();
    }

    public void writeToPacketStream(FriendlyByteBuf stream, Level level) {
        SerializerMark<T> serializerMark = this.getSerializer();
        if (serializerMark instanceof SimpleSerializer) {
            SimpleSerializer simple = (SimpleSerializer)serializerMark;
            simple.writePacketStream(stream, this.objInstance);
        } else {
            serializerMark = this.getSerializer();
            if (serializerMark instanceof WorldDataSerializer) {
                WorldDataSerializer worldData = (WorldDataSerializer)serializerMark;
                worldData.writePacketStream(stream, level, this.objInstance);
            } else {
                serializerMark = this.getSerializer();
                if (serializerMark instanceof EntityDataSerializer) {
                    EntityDataSerializer entityData = (EntityDataSerializer)serializerMark;
                    entityData.writePacketStream(stream, level, this.objInstance);
                }
            }
        }
    }

    public T readFromPacketStream(FriendlyByteBuf stream, Level level) {
        SerializerMark<T> serializerMark = this.getSerializer();
        if (serializerMark instanceof SimpleSerializer) {
            SimpleSerializer simple = (SimpleSerializer)serializerMark;
            this.set(simple.readPacketStream(stream));
        } else {
            serializerMark = this.getSerializer();
            if (serializerMark instanceof WorldDataSerializer) {
                WorldDataSerializer worldData = (WorldDataSerializer)serializerMark;
                this.set(worldData.readPacketStream(stream, level));
            } else {
                serializerMark = this.getSerializer();
                if (serializerMark instanceof EntityDataSerializer) {
                    EntityDataSerializer entityData = (EntityDataSerializer)serializerMark;
                    this.set(entityData.readPacketStream(stream, this.objInstance, level));
                }
            }
        }
        this.checkInvalidReadObject();
        return this.objInstance;
    }

    public void writeToNBT(CompoundTag nbt, Level level) {
        SerializerMark<T> serializerMark = this.getSerializer();
        if (serializerMark instanceof SimpleSerializer) {
            SimpleSerializer simple = (SimpleSerializer)serializerMark;
            simple.writeNBT(nbt, this.objInstance, this.reference.storageKey());
        } else {
            serializerMark = this.getSerializer();
            if (serializerMark instanceof WorldDataSerializer) {
                WorldDataSerializer worldData = (WorldDataSerializer)serializerMark;
                worldData.writeNBT(nbt, this.objInstance, level, this.reference.storageKey());
            } else {
                serializerMark = this.getSerializer();
                if (serializerMark instanceof EntityDataSerializer) {
                    EntityDataSerializer entityData = (EntityDataSerializer)serializerMark;
                    entityData.writeNBT(nbt, this.objInstance, level, this.reference.storageKey());
                }
            }
        }
    }

    public T readFromNBT(CompoundTag nbt, Level level) {
        SerializerMark<T> serializerMark = this.getSerializer();
        if (serializerMark instanceof SimpleSerializer) {
            SimpleSerializer simple = (SimpleSerializer)serializerMark;
            this.set(simple.readNBT(nbt, this.reference.storageKey()));
        } else {
            serializerMark = this.getSerializer();
            if (serializerMark instanceof WorldDataSerializer) {
                WorldDataSerializer worldData = (WorldDataSerializer)serializerMark;
                this.set(worldData.readNBT(nbt, level, this.reference.storageKey()));
            } else {
                serializerMark = this.getSerializer();
                if (serializerMark instanceof EntityDataSerializer) {
                    EntityDataSerializer entityData = (EntityDataSerializer)serializerMark;
                    this.set(entityData.readNBT(nbt, this.objInstance, level, this.reference.storageKey()));
                }
            }
        }
        this.checkInvalidReadObject();
        return this.objInstance;
    }

    private void checkInvalidReadObject() {
        if (this.objInstance == null) {
            this.objInstance = this.reference.defaultProvider().get();
        }
    }
}

