/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.entity.psyche.targeting;

import bottomtextdanny.braincell.mod.entity.psyche.targeting.TargetPredicate;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.TargetRange;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class Targeter
implements TargetPredicate {
    private final TargetRange targetRange;
    @Nullable
    private final TargetRange targetRangeForInvisible;
    private final boolean forCombat;

    private Targeter(TargetRange targetRange, @Nullable TargetRange targetRangeForInvisible, boolean beOnSight, boolean forCombat) {
        this.targetRange = targetRange;
        this.targetRangeForInvisible = targetRangeForInvisible;
        this.forCombat = forCombat;
    }

    @Override
    public boolean test(Mob selector, LivingEntity posibleTarget) {
        if (selector == null || selector == posibleTarget) {
            return false;
        }
        if (!posibleTarget.m_142065_()) {
            return false;
        }
        if (this.forCombat && (!selector.m_6779_(posibleTarget) || !selector.m_6549_(posibleTarget.m_6095_()) || selector.m_7307_((Entity)posibleTarget))) {
            return false;
        }
        if (posibleTarget.m_20145_()) {
            return this.targetRangeForInvisible != null && this.targetRangeForInvisible.test(selector, posibleTarget);
        }
        return this.targetRange.test(selector, posibleTarget);
    }

    public static class Builder {
        private final TargetRange targetRange;
        @Nullable
        private TargetRange targetRangeForInvisible;
        private boolean hasToBeOnSight;
        private boolean forCombat;

        private Builder(TargetRange targetRange) {
            this.targetRange = targetRange;
        }

        public static <T extends LivingEntity> Builder start(TargetRange targetRange) {
            return new Builder(targetRange);
        }

        public Builder targetRangeForInvisible(TargetRange targetRangeForInvisible) {
            this.targetRangeForInvisible = targetRangeForInvisible;
            return this;
        }

        public Builder hasToBeOnSight() {
            this.hasToBeOnSight = true;
            return this;
        }

        public Builder isForCombat() {
            this.forCombat = true;
            return this;
        }

        public Targeter build() {
            return new Targeter(this.targetRange, this.targetRangeForInvisible, this.hasToBeOnSight, this.forCombat);
        }
    }
}

