/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.entity.psyche.targeting;

import bottomtextdanny.braincell.mod.entity.psyche.targeting.MobMatchPredicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class TargetRange
implements MobMatchPredicate<Entity> {
    private TargetRange() {
    }

    public static TargetRange followRangeMultiplied(float factor) {
        return new ByFollowRange(factor);
    }

    public static TargetRange followRange() {
        return new ByFollowRange(1.0f);
    }

    public static TargetRange fixedRange(double distance) {
        return new Fixed(distance);
    }

    private static final class ByFollowRange
    extends TargetRange {
        private final float multiplier;

        public ByFollowRange(float multiplier) {
            this.multiplier = multiplier;
        }

        @Override
        public boolean test(Mob opinionated, Entity entity) {
            return (double)opinionated.m_20270_(entity) < opinionated.m_21051_(Attributes.f_22277_).m_22135_() * (double)this.multiplier;
        }
    }

    private static final class Fixed
    extends TargetRange {
        private final double distance;

        public Fixed(double distance) {
            this.distance = distance;
        }

        @Override
        public boolean test(Mob opinionated, Entity entity) {
            return (double)opinionated.m_20270_(entity) < this.distance;
        }
    }
}

