/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.entity.psyche.targeting;

import bottomtextdanny.braincell.mod.entity.psyche.targeting.SearchPredicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;

public final class SearchPredicates {
    public static SearchPredicate<Player> nearestPlayer() {
        return (mob, level, radius, searchArea, post) -> {
            Player player = null;
            double d0 = -1.0;
            for (Player player1 : level.m_6907_()) {
                double d1 = radius.test(player1.m_20185_(), player1.m_20186_(), player1.m_20189_());
                if (!(d1 > 0.0) || d0 != -1.0 && !(d1 < d0) || !post.test(mob, player1)) continue;
                d0 = d1;
                player = player1;
            }
            return player;
        };
    }

    public static SearchPredicate<LivingEntity> nearestLiving() {
        return (mob, level, radius, searchArea, post) -> {
            LivingEntity[] t = new LivingEntity[]{null};
            double[] d0 = new double[]{-1.0};
            level.m_142646_().m_142137_(EntityTypeTest.m_156916_(LivingEntity.class), (AABB)searchArea.get(), le -> {
                double d1 = radius.test(le.m_20185_(), le.m_20186_(), le.m_20189_());
                if (d1 > 0.0 && (d0[0] == -1.0 || d1 < d0[0]) && post.test(mob, le)) {
                    d0[0] = d1;
                    t[0] = le;
                }
            });
            return t[0];
        };
    }

    public static SearchPredicate<Entity> nearestEntity() {
        return (mob, level, radius, searchArea, post) -> {
            Entity[] t = new Entity[]{null};
            double[] d0 = new double[]{-1.0};
            level.m_142646_().m_142137_(EntityTypeTest.m_156916_(Entity.class), (AABB)searchArea.get(), le -> {
                double d1 = radius.test(le.m_20185_(), le.m_20186_(), le.m_20189_());
                if (d1 > 0.0 && (d0[0] == -1.0 || d1 < d0[0]) && post.test(mob, le)) {
                    d0[0] = d1;
                    t[0] = le;
                }
            });
            return t[0];
        };
    }

    public static <T extends Entity> SearchPredicate<T> nearestEntityOfType(Class<T> clazz) {
        return (mob, level, radius, searchArea, post) -> {
            Entity[] t = new Entity[]{null};
            double[] d0 = new double[]{-1.0};
            level.m_142646_().m_142137_(EntityTypeTest.m_156916_((Class)clazz), (AABB)searchArea.get(), entity -> {
                double d1 = radius.test(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                if (d1 > 0.0 && (d0[0] == -1.0 || d1 < d0[0]) && post.test(mob, entity)) {
                    d0[0] = d1;
                    t[0] = entity;
                }
            });
            return t[0];
        };
    }

    private SearchPredicates() {
    }
}

