/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.entity.psyche.targeting;

import bottomtextdanny.braincell.mod.entity.psyche.targeting.MobMatchPredicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;

public class MobMatchPredicates {
    public static MobMatchPredicate<Object> byClass(Class<?> clazz) {
        return (m, t) -> t.getClass().isAssignableFrom(clazz);
    }

    public static MobMatchPredicate<Object> byClasses(Class<?> ... classes) {
        return (m, t) -> {
            for (Class cl : classes) {
                if (!t.getClass().isAssignableFrom(cl)) continue;
                return true;
            }
            return false;
        };
    }

    public static MobMatchPredicate<Object> excludeByClass(Class<? extends LivingEntity> clazz) {
        return (m, t) -> !t.getClass().isAssignableFrom(clazz);
    }

    public static MobMatchPredicate<Object> excludeByClasses(Class<?> ... classes) {
        return (m, t) -> {
            for (Class cl : classes) {
                if (!t.getClass().isAssignableFrom(cl)) continue;
                return false;
            }
            return true;
        };
    }

    public static MobMatchPredicate<Entity> noCreativeOrSpectator() {
        return (m, t) -> EntitySelector.f_20406_.test(t);
    }

    public static MobMatchPredicate<Entity> canBeCollidedWith() {
        return (m, t) -> EntitySelector.f_185987_.test(t);
    }

    public static MobMatchPredicate<Entity> notBeingRidden() {
        return (m, t) -> EntitySelector.f_20404_.test(t);
    }

    public static MobMatchPredicate<Entity> alive() {
        return (m, t) -> EntitySelector.f_20403_.test(t);
    }

    public static MobMatchPredicate<Entity> notRiding(Entity mount) {
        return (m, t) -> EntitySelector.m_20431_((Entity)mount).test(t);
    }

    public static MobMatchPredicate<Entity> notRiding() {
        return (m, t) -> t.m_20159_();
    }

    public static MobMatchPredicate<Entity> pushableBy(Entity pusher) {
        return (m, t) -> EntitySelector.m_20421_((Entity)pusher).test(t);
    }

    public static MobMatchPredicate<Entity> withingDistance(double x, double y, double z, double distance) {
        return (m, t) -> EntitySelector.m_20410_((double)x, (double)y, (double)z, (double)distance).test(t);
    }
}

