/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.entity.psyche.pos_finder;

import bottomtextdanny.braincell.base.BCMath;
import bottomtextdanny.braincell.base.FloatRandomPicker;
import bottomtextdanny.braincell.base.value_mapper.FloatMapper;
import bottomtextdanny.braincell.mod.entity.psyche.pos_finder.IfElseConstructorProcessor;
import bottomtextdanny.braincell.mod.entity.psyche.pos_finder.MobPosComparators;
import bottomtextdanny.braincell.mod.entity.psyche.pos_finder.MobPosPredicate;
import bottomtextdanny.braincell.mod.entity.psyche.pos_finder.MobPosPredicates;
import bottomtextdanny.braincell.mod.entity.psyche.pos_finder.MobPosProcessor;
import bottomtextdanny.braincell.mod.entity.psyche.pos_finder.MobPosStackProcessor;
import java.util.Comparator;
import java.util.function.Function;
import java.util.random.RandomGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;

public final class MobPosProcessors {
    private static final MobPosProcessor<LivingEntity> AVOID = MobPosProcessors.compose((blockPos, mob, randomGenerator, target) -> {
        Vec3 posDiff = mob.m_20182_().m_82546_(target.m_20182_());
        float oppositeFromTargetRad = (float)Mth.m_14136_((double)posDiff.f_82481_, (double)posDiff.f_82479_) + (float)Math.PI;
        FloatMapper angleAwayFromTarget = FloatMapper.from(oppositeFromTargetRad - 0.5235988f, oppositeFromTargetRad + 0.5235988f, FloatRandomPicker.normal());
        FloatMapper stepAway = FloatMapper.of(10.0f);
        return ((MobPosStackProcessor)MobPosProcessors.stack().generic(LivingEntity.class)).push(MobPosProcessors.advanceHorizontal(angleAwayFromTarget, stepAway)).push(MobPosProcessors.sample(10, MobPosProcessors.stack().push(MobPosProcessors.randomOffset(5, 4, 5)).push(MobPosProcessors.moveIf(Direction.DOWN, 16, MobPosPredicates.isSolid().negate())).push(MobPosProcessors.offset(0, 1, 0)), MobPosComparators.compareWalkValue(mob)));
    });

    public static <T> MobPosProcessor<T> compose(MobPosFunction<T> processor) {
        return (pos, mob, r, ex) -> processor.apply(pos, mob, r, ex).compute(pos, mob, r, ex);
    }

    public static <T> MobPosStackProcessor<T> stack() {
        return new MobPosStackProcessor();
    }

    public static <T> MobPosStackProcessor<T> stack(Class<T> infer) {
        return new MobPosStackProcessor();
    }

    public static <T> MobPosProcessor<T> randomOffset(int xAxis, int yAxis, int zAxis) {
        return (pos, mob, r, extra) -> pos.m_142082_(r.nextInt(-xAxis, xAxis), r.nextInt(-yAxis, yAxis), r.nextInt(-zAxis, zAxis));
    }

    public static <T> MobPosProcessor<T> offset(int x, int y, int z) {
        return (pos, mob, r, extra) -> pos.m_142082_(x, y, z);
    }

    public static <T> MobPosProcessor<T> advanceHorizontal(FloatMapper radianAngleMapper, FloatMapper stepMapper) {
        return (pos, mob, r, extra) -> {
            float radianAngle = radianAngleMapper.map(r);
            float step = stepMapper.map(r);
            return pos.m_142022_((double)(BCMath.sin(radianAngle) * step), 0.0, (double)(BCMath.cos(radianAngle) * step));
        };
    }

    public static <T> MobPosProcessor<T> advance(FloatMapper radianVerticalAngleMapper, FloatMapper radianHorizontalAngleMapper, FloatMapper stepMapper) {
        return (pos, mob, r, extra) -> {
            Vec3 vec = Vec3.m_82498_((float)radianVerticalAngleMapper.map(r), (float)radianHorizontalAngleMapper.map(r)).m_82490_((double)stepMapper.map(r));
            return pos.m_142022_(vec.f_82479_, vec.f_82480_, vec.f_82481_);
        };
    }

    public static <T> MobPosProcessor<T> find(int tries, MobPosProcessor<? super T> processor) {
        return (pos, mob, r, extra) -> {
            for (int i = 0; i < tries; ++i) {
                BlockPos att = processor.compute(pos, mob, r, extra);
                if (att == null) continue;
                return att;
            }
            return null;
        };
    }

    public static <T> MobPosProcessor<T> sample(int tries, MobPosProcessor<? super T> processor, Function<? super T, Comparator<BlockPos>> posComparatorGetter) {
        return (pos, mob, r, extra) -> {
            BlockPos newPos = null;
            Comparator comparator = (Comparator)posComparatorGetter.apply(extra);
            for (int i = 0; i < tries; ++i) {
                BlockPos att = processor.compute(pos, mob, r, extra);
                if (newPos != null && (att == null || comparator.compare(newPos, att) <= 0)) continue;
                newPos = att;
            }
            return newPos;
        };
    }

    public static <T> MobPosProcessor<T> moveIf(Direction direction, int max, MobPosPredicate<? super T> predicate) {
        return (pos, mob, r, extra) -> {
            BlockPos.MutableBlockPos mu = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            for (int i = 0; i < max && predicate.test(mob, (BlockPos)mu, extra); ++i) {
                mu.m_122173_(direction);
            }
            return new BlockPos((Vec3i)mu);
        };
    }

    public static <T> MobPosProcessor<T> move(Direction direction, FloatMapper distance) {
        return (pos, mob, r, extra) -> pos.m_5484_(direction, (int)distance.map(r));
    }

    public static <T> MobPosProcessor<T> pred(MobPosPredicate<? super T> predicate) {
        return (pos, mob, r, extra) -> predicate.test(mob, pos, extra) ? pos : null;
    }

    public static <T> IfElseConstructorProcessor<T> testNull(MobPosProcessor<? super T> positiveProcessor) {
        return new IfElseConstructorProcessor<T>(positiveProcessor);
    }

    private MobPosProcessors() {
    }

    @FunctionalInterface
    public static interface MobPosFunction<T> {
        public MobPosProcessor<T> apply(BlockPos var1, Mob var2, RandomGenerator var3, T var4);
    }
}

