/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.entity.psyche.pos_finder;

import bottomtextdanny.braincell.mod.entity.psyche.pos_finder.MobPosPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public final class MobPosPredicates {
    public <T> boolean insideWorldHeight(LevelAccessor level, BlockPos pos, T extra) {
        return pos.m_123342_() < level.m_141937_() || pos.m_123342_() > level.m_151558_();
    }

    public static <T> MobPosPredicate<T> unrestricted(PathfinderMob mob) {
        return (entity, bp, extra) -> !mob.m_21444_(bp);
    }

    public static <T> MobPosPredicate<T> noMalus() {
        return (entity, bp, extra) -> entity.m_21439_(WalkNodeEvaluator.m_77604_((BlockGetter)entity.f_19853_, (BlockPos.MutableBlockPos)bp.m_122032_())) <= 0.0f;
    }

    public static <T> MobPosPredicate<T> isWater() {
        return (entity, bp, extra) -> {
            FluidState fluidState = entity.f_19853_.m_8055_(bp).m_60819_();
            return fluidState.m_192917_((Fluid)Fluids.f_76193_) || fluidState.m_192917_((Fluid)Fluids.f_76192_);
        };
    }

    public static <T> MobPosPredicate<T> isLava() {
        return (entity, bp, extra) -> {
            FluidState fluidState = entity.f_19853_.m_8055_(bp).m_60819_();
            return fluidState.m_192917_((Fluid)Fluids.f_76195_) || fluidState.m_192917_((Fluid)Fluids.f_76194_);
        };
    }

    public static <T> MobPosPredicate<T> noFluid() {
        return (entity, bp, extra) -> entity.f_19853_.m_8055_(bp).m_60819_().m_192917_(Fluids.f_76191_);
    }

    public static <T> MobPosPredicate<T> isSolid() {
        return (entity, bp, extra) -> entity.f_19853_.m_8055_(bp).m_60767_().m_76333_();
    }

    public static <T> MobPosPredicate<T> isStable() {
        return (entity, bp, extra) -> entity.f_19853_.m_8055_(bp).m_60804_((BlockGetter)entity.f_19853_, bp);
    }

    public static <T> MobPosPredicate<T> is(Block blockState) {
        return (entity, bp, extra) -> entity.f_19853_.m_8055_(bp).m_60734_() == blockState;
    }

    public static <T> MobPosPredicate<T> has(TagKey<Block> blockState) {
        return (entity, bp, extra) -> entity.f_19853_.m_8055_(bp).m_60734_().m_204297_().m_203656_(blockState);
    }

    public static <T> MobPosPredicate<T> blocksMotion() {
        return (entity, bp, extra) -> entity.f_19853_.m_8055_(bp).m_60767_().m_76334_();
    }

    private MobPosPredicates() {
    }
}

