/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.entity.psyche.actions.target;

import bottomtextdanny.braincell.base.scheduler.IntScheduler;
import bottomtextdanny.braincell.base.vector.DistanceCalc3;
import bottomtextdanny.braincell.mod.entity.psyche.MarkedTimer;
import bottomtextdanny.braincell.mod.entity.psyche.actions.OccasionalThoughtAction;
import bottomtextdanny.braincell.mod.entity.psyche.input.ActionInputKey;
import bottomtextdanny.braincell.mod.entity.psyche.input.ActionInputs;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.MobMatchPredicate;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.RangeTest;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.SearchPredicate;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.TargetPredicates;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.Lazy;

public class LookForAttackTargetAction<E extends PathfinderMob>
extends OccasionalThoughtAction<E> {
    public static final int DEFAULT_UPDATE_INTERVAL = 4;
    @Nullable
    private BiConsumer<Mob, LivingEntity> findTargetCallOut;
    @Nullable
    protected MobMatchPredicate<LivingEntity> targetPredicate;
    protected SearchPredicate<LivingEntity> searchPredicate;
    protected LivingEntity targetAsLocal;

    public LookForAttackTargetAction(E mob, IntScheduler updateInterval, MobMatchPredicate<? super LivingEntity> targeter, SearchPredicate<? extends LivingEntity> searcher) {
        super(mob, updateInterval);
        this.targetPredicate = targeter.cast();
        this.searchPredicate = searcher.hackyCast();
    }

    public LookForAttackTargetAction<E> findTargetCallOut(BiConsumer<Mob, LivingEntity> callOut) {
        this.findTargetCallOut = callOut;
        return this;
    }

    protected Lazy<AABB> getTargetSearchArea(double p_26069_) {
        return Lazy.of(() -> this.mob.m_142469_().m_82377_(p_26069_, 4.0, p_26069_));
    }

    protected double getFollowDistance() {
        return this.mob.m_21133_(Attributes.f_22277_);
    }

    @Override
    public void thoughtAction(int timeSinceBefore) {
        ActionInputs inputs = this.getPsyche().getInputs();
        if (inputs.containsInput(ActionInputKey.MARKED_UNSEEN)) {
            MobMatchPredicate<LivingEntity> sightPredicate = inputs.getOfDefault(ActionInputKey.SEE_TARGET_PREDICATE);
            boolean previousLocalTargetIsNull = this.targetAsLocal == null;
            MarkedTimer markedUnseen = inputs.get(ActionInputKey.MARKED_UNSEEN).get();
            this.processTarget(sightPredicate, markedUnseen, previousLocalTargetIsNull);
        }
    }

    protected void processTarget(MobMatchPredicate<LivingEntity> sightPredicate, MarkedTimer markedUnseen, boolean previousLocalTargetIsNull) {
        if (!markedUnseen.isMarkedBy(this) && this.getPsyche().getInputs().getOfDefault(ActionInputKey.TARGET_VALIDATOR).test((Mob)this.mob, this.mob.m_5448_())) {
            return;
        }
        if (markedUnseen.isUnmarkedOrMarkedBy(this)) {
            if (this.targetAsLocal == null) {
                markedUnseen.timer.end();
            } else if (this.mob.m_21574_().m_148306_((Entity)this.targetAsLocal)) {
                markedUnseen.timer.reset();
            } else {
                markedUnseen.timer.advance();
            }
        }
        if (this.targetAsLocal != null) {
            boolean previousTargetIsStillValid = this.targetPredicate.and(TargetPredicates.noCreativeOrSpectator()).test((Mob)this.mob, this.targetAsLocal);
            if (!markedUnseen.timer.hasEnded() && previousTargetIsStillValid) {
                markedUnseen.setMarkedBy(this);
            } else {
                if (markedUnseen.isMarkedBy(this)) {
                    markedUnseen.unmark();
                }
                this.targetAsLocal = null;
            }
        }
        if (this.targetAsLocal == null) {
            this.targetAsLocal = this.searchPredicate.search((Mob)this.mob, (ServerLevel)this.mob.f_19853_, RangeTest.awayFrom((Mob)this.mob, this.getFollowDistance(), DistanceCalc3.MANHATTAN), this.getTargetSearchArea(this.getFollowDistance()), this.targetPredicate.and(sightPredicate).and(TargetPredicates.noCreativeOrSpectator()));
            if (this.targetAsLocal != null) {
                markedUnseen.setMarkedBy(this);
                if (previousLocalTargetIsNull) {
                    this.mob.m_21573_().m_26573_();
                }
            } else if (markedUnseen.isMarkedBy(this)) {
                markedUnseen.unmark();
            }
        }
        if (markedUnseen.isMarkedBy(this) && previousLocalTargetIsNull) {
            Runnable newTargetInput = this.getPsyche().getInputs().get(ActionInputKey.SET_TARGET_CALL);
            if (newTargetInput != null) {
                newTargetInput.run();
            }
            if (this.findTargetCallOut != null) {
                this.findTargetCallOut.accept((Mob)this.mob, this.targetAsLocal);
            }
        }
        if (this.targetAsLocal != null && markedUnseen.isMarkedBy(this)) {
            this.mob.m_6710_(this.targetAsLocal);
        }
    }

    @Override
    public boolean cancelNext() {
        if (this.getPsyche().getInputs().containsInput(ActionInputKey.MARKED_UNSEEN)) {
            MarkedTimer markedUnseen = this.getPsyche().getInputs().get(ActionInputKey.MARKED_UNSEEN).get();
            return markedUnseen.isMarkedBy(this);
        }
        return false;
    }
}

