/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.entity.psyche.actions;

import bottomtextdanny.braincell.base.value_mapper.RandomIntegerMapper;
import bottomtextdanny.braincell.mod.entity.psyche.Action;
import bottomtextdanny.braincell.mod.entity.psyche.pos_finder.MobPosProcessor;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class RandomStrollAction
extends Action<PathfinderMob> {
    public static final RandomIntegerMapper DEFAULT_STROLL_TIME = RandomIntegerMapper.of(120, 150);
    protected RandomIntegerMapper strollTime;
    private final MobPosProcessor<?> posProcessor;
    protected int timeTillStroll;
    protected float speedModifier = 1.0f;
    protected Path path;

    public RandomStrollAction(PathfinderMob mob, MobPosProcessor<?> posProcessor, RandomIntegerMapper strollTime) {
        super(mob);
        this.strollTime = strollTime;
        this.posProcessor = posProcessor;
        this.timeTillStroll = strollTime.map(UNSAFE_RANDOM);
    }

    public void setSpeedModifier(float newSpeed) {
        this.speedModifier = newSpeed;
    }

    @Override
    public boolean canStart() {
        if (!this.active()) {
            return false;
        }
        if (this.mob.m_20160_()) {
            return false;
        }
        if (this.timeTillStroll > 0) {
            --this.timeTillStroll;
            return false;
        }
        this.timeTillStroll = this.strollTime.map(UNSAFE_RANDOM);
        Vec3 randomPos = this.getRandomPosition();
        if (randomPos == null) {
            return false;
        }
        this.path = this.mob.m_21573_().m_26524_(randomPos.f_82479_, randomPos.f_82480_, randomPos.f_82481_, 0);
        return this.path != null;
    }

    @Override
    public void start() {
        this.mob.m_21573_().m_26536_(this.path, (double)this.speedModifier);
    }

    @Override
    public boolean shouldKeepGoing() {
        return !this.mob.m_21573_().m_26571_() && !this.mob.m_21573_().m_26577_() && !this.mob.m_20160_() && this.active();
    }

    @Override
    public void onEnd() {
        super.onEnd();
        this.mob.m_21573_().m_26573_();
    }

    @Nullable
    protected Vec3 getRandomPosition() {
        BlockPos pos = this.posProcessor.compute(this.mob.m_142538_(), (Mob)this.mob, UNSAFE_RANDOM, null);
        if (pos != null) {
            return Vec3.m_82512_((Vec3i)pos);
        }
        return null;
    }
}

