/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.entity.psyche.actions;

import bottomtextdanny.braincell.base.vector.DistanceCalc3;
import bottomtextdanny.braincell.mod.entity.psyche.Action;
import bottomtextdanny.braincell.mod.entity.psyche.pos_finder.MobPosProcessor;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.MobMatchPredicate;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.MobMatchPredicates;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.RangeTest;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.SearchPredicate;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.SearchPredicates;
import java.util.function.BiConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.Lazy;

public class MoveReactionToEntityAction<T extends PathfinderMob, U extends Entity>
extends Action<T> {
    public static int DEFAULT_PATH_REFRESH_RATE = 4;
    private final MobPosProcessor<U> posFinder;
    private final MobMatchPredicate<U> mobFinder;
    private ToDoubleFunction<U> moveSpeedByTarget;
    private SearchPredicate<U> searchPredicate;
    private BiConsumer<T, U> focusFoundCallout;
    private DoubleSupplier searchRange;
    @Nullable
    private U focus;
    @Nullable
    private Path goal;
    private int refreshRate = DEFAULT_PATH_REFRESH_RATE;

    public MoveReactionToEntityAction(T mob, MobMatchPredicate<? super U> mobPredicate, MobPosProcessor<? super U> posFinder) {
        super(mob);
        this.mobFinder = mobPredicate.cast();
        this.posFinder = posFinder.cast();
        this.moveSpeedByTarget = target -> 1.0;
        this.searchRange = () -> mob.m_21133_(Attributes.f_22277_);
        this.searchPredicate = SearchPredicates.nearestEntity().cast();
    }

    public MoveReactionToEntityAction<T, U> setRefreshRate(int refreshRate) {
        this.refreshRate = refreshRate;
        return this;
    }

    public MoveReactionToEntityAction<T, U> searchBy(SearchPredicate<? super U> predicate) {
        this.searchPredicate = predicate;
        return this;
    }

    public MoveReactionToEntityAction<T, U> speedByTarget(ToDoubleFunction<? super U> moveSpeedByTarget) {
        this.moveSpeedByTarget = moveSpeedByTarget;
        return this;
    }

    public MoveReactionToEntityAction<T, U> searchRange(DoubleSupplier searchRange) {
        this.searchRange = searchRange;
        return this;
    }

    public MoveReactionToEntityAction<T, U> onFocusFound(BiConsumer<? super T, ? super U> callout) {
        this.focusFoundCallout = callout;
        return this;
    }

    @Override
    public boolean canStart() {
        if (this.focus == null) {
            this.updateFocus();
        }
        U focus = this.focus;
        if (this.active() && !this.mob.m_20160_() && focus != null) {
            BlockPos goalPos = this.posFinder.compute(this.mob.m_142538_(), (Mob)this.mob, UNSAFE_RANDOM, focus);
            if (goalPos == null) {
                return false;
            }
            this.goal = this.mob.m_21573_().m_7864_(goalPos, 0);
            return this.goal != null;
        }
        return false;
    }

    @Override
    protected void start() {
        this.mob.m_21573_().m_26536_(this.goal, this.moveSpeedByTarget.applyAsDouble(this.focus));
    }

    @Override
    protected void update() {
        if (this.ticksPassed % this.refreshRate == 0) {
            if (EntitySelector.f_20406_.test(this.focus) && this.mob.m_21573_().m_26571_() && !this.goal.m_77392_()) {
                this.onPathUpdate();
            } else {
                this.goal = null;
                this.focus = null;
                this.mob.m_21573_().m_26573_();
            }
        }
    }

    protected void onPathUpdate() {
        U entity = this.focus;
        this.mob.m_21573_().m_26536_(this.goal, this.moveSpeedByTarget.applyAsDouble(entity));
    }

    @Override
    public void onEnd() {
        super.onEnd();
        this.focus = null;
        this.goal = null;
        this.mob.m_21573_().m_26573_();
    }

    @Override
    public boolean shouldKeepGoing() {
        return this.active() && !this.mob.m_20160_() && this.goal != null && this.mob.m_21573_().m_26572_() && !this.mob.m_21573_().m_26577_() && this.focus != null && this.focus.m_6084_();
    }

    protected void updateFocus() {
        double range = this.searchRange.getAsDouble();
        U entity = this.focus;
        this.focus = this.searchPredicate.search((Mob)this.mob, (ServerLevel)this.mob.f_19853_, RangeTest.awayFrom((Mob)this.mob, range, DistanceCalc3.MANHATTAN), this.getTargetSearchArea(range), this.mobFinder.and(MobMatchPredicates.noCreativeOrSpectator()));
        if (this.focusFoundCallout != null && entity != this.focus) {
            this.focusFoundCallout.accept(this.mob, this.focus);
        }
    }

    public void inferFocus(U newFocus) {
        this.focus = newFocus;
    }

    protected Lazy<AABB> getTargetSearchArea(double p_26069_) {
        return Lazy.of(() -> this.mob.m_142469_().m_82377_(p_26069_, 4.0, p_26069_));
    }

    @Nullable
    public U getFocus() {
        return this.focus;
    }
}

