/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.entity.psyche.actions;

import bottomtextdanny.braincell.base.BCMath;
import bottomtextdanny.braincell.base.value_mapper.FloatMapper;
import bottomtextdanny.braincell.base.value_mapper.FloatMappers;
import bottomtextdanny.braincell.base.value_mapper.RandomIntegerMapper;
import bottomtextdanny.braincell.mod.entity.psyche.Action;
import net.minecraft.world.entity.PathfinderMob;

public class LookRandomlyAction
extends Action<PathfinderMob> {
    private static final RandomIntegerMapper DEFAULT_COOLDOWN_MAPPER = RandomIntegerMapper.of(150, 220);
    private static final FloatMapper NO_VERTICAL_ROTATION = FloatMappers.of(0.0f);
    private final RandomIntegerMapper cooldownMapper;
    private FloatMapper yLookLocationMapper = NO_VERTICAL_ROTATION;
    private int lookCooldownTracker;
    private float lookX;
    private float lookY;
    private float lookZ;
    private int lookTime;

    public LookRandomlyAction(PathfinderMob mob, RandomIntegerMapper cooldownMapper) {
        super(mob);
        this.cooldownMapper = cooldownMapper;
    }

    public LookRandomlyAction(PathfinderMob mob) {
        this(mob, DEFAULT_COOLDOWN_MAPPER);
    }

    public LookRandomlyAction vertical(FloatMapper mapper) {
        this.yLookLocationMapper = mapper;
        return this;
    }

    @Override
    public boolean canStart() {
        if (!this.active()) {
            return false;
        }
        if (this.lookCooldownTracker > 0) {
            --this.lookCooldownTracker;
            return false;
        }
        this.lookCooldownTracker = this.cooldownMapper.map(UNSAFE_RANDOM);
        return true;
    }

    @Override
    protected void start() {
        float d0 = (float)Math.PI * 2 * this.mob.m_21187_().nextFloat();
        this.lookX = BCMath.cos(d0);
        this.lookY = this.yLookLocationMapper.map(UNSAFE_RANDOM);
        this.lookZ = BCMath.sin(d0);
        this.lookTime = 20 + UNSAFE_RANDOM.nextInt(20);
    }

    @Override
    protected void update() {
        --this.lookTime;
        this.mob.m_21563_().m_24946_(this.mob.m_20185_() + (double)this.lookX, this.mob.m_20188_() + (double)this.lookY, this.mob.m_20189_() + (double)this.lookZ);
    }

    @Override
    public boolean shouldKeepGoing() {
        return this.lookTime > 0;
    }
}

