/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.entity.psyche.actions;

import bottomtextdanny.braincell.mod.entity.psyche.Action;
import bottomtextdanny.braincell.mod.world.helpers.ReachHelper;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.pathfinder.Path;

public class FollowTargetAction<E extends PathfinderMob>
extends Action<E> {
    public static int DEFAULT_PATH_REFRESH_RATE = 4;
    public static int INITIALIZE_REFRESH_RATE = 10;
    private final ToDoubleFunction<LivingEntity> moveSpeed;
    private int refreshRate = DEFAULT_PATH_REFRESH_RATE;
    @Nullable
    private Predicate<LivingEntity> stopPredicate;
    private Path path;

    public FollowTargetAction(E mob, ToDoubleFunction<LivingEntity> moveSpeed) {
        super(mob);
        this.moveSpeed = moveSpeed;
    }

    public FollowTargetAction<E> setRefreshRate(int refreshRate) {
        this.refreshRate = refreshRate;
        return this;
    }

    public FollowTargetAction<E> setStopPredicate(Predicate<LivingEntity> stopPredicate) {
        this.stopPredicate = stopPredicate;
        return this;
    }

    @Override
    protected void start() {
        this.mob.m_21573_().m_26536_(this.path, this.moveSpeed.applyAsDouble(this.mob.m_5448_()));
        this.mob.m_21561_(true);
    }

    @Override
    public boolean canStart() {
        LivingEntity livingEntity = this.mob.m_5448_();
        if (!this.active() || livingEntity == null || !livingEntity.m_6084_()) {
            return false;
        }
        this.path = this.mob.m_21573_().m_6570_((Entity)livingEntity, 0);
        return this.path != null;
    }

    @Override
    protected void update() {
        if (this.mob.m_5448_() == null || !this.mob.m_5448_().m_6084_() || !EntitySelector.f_20406_.test(this.mob.m_5448_())) {
            this.mob.m_21573_().m_26573_();
            return;
        }
        this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 20.0f);
        if (this.ticksPassed % this.refreshRate == 0) {
            this.onPathUpdate();
        }
    }

    public void onPathUpdate() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (this.stopPredicate != null && this.stopPredicate.test(livingentity) || ReachHelper.reachSqr(this.mob, (Entity)this.mob.m_5448_()) < 0.5f) {
            this.mob.m_21573_().m_26573_();
        } else {
            this.mob.m_21573_().m_5624_((Entity)livingentity, this.moveSpeed.applyAsDouble(livingentity));
        }
    }

    @Override
    public void onEnd() {
        super.onEnd();
        this.mob.m_21573_().m_26573_();
    }

    @Override
    public boolean shouldKeepGoing() {
        return this.active() && (this.mob.m_21573_().m_26570_() == null || !this.mob.m_21573_().m_26571_()) && this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_();
    }
}

