/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.entity.psyche.actions;

import bottomtextdanny.braincell.mod.entity.psyche.actions.ConstantThoughtAction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;

public class FloatAction
extends ConstantThoughtAction<PathfinderMob> {
    public static final float DEFAULT_FLOAT_HEIGHT = 0.5f;
    public static final int DETECT_GROUND_REFRESH_RATE = 14;
    private final float floatHeight;
    private boolean cachedDetectedGroundState;

    public FloatAction(PathfinderMob mob, float floatHeight) {
        super(mob, null);
        this.floatHeight = floatHeight;
        mob.m_21573_().m_7008_(true);
        this.cachedDetectedGroundState = true;
    }

    public FloatAction(PathfinderMob mob) {
        this(mob, 0.5f);
    }

    @Override
    protected void update() {
        double fluidHeight = this.mob.m_204036_(FluidTags.f_13131_);
        if (fluidHeight > 0.15 && this.ticksPassed % 14 == 0) {
            float reducedHeight = this.mob.m_20192_() - 0.15f;
            this.cachedDetectedGroundState = this.detectGround(reducedHeight);
        }
        if ((this.mob.m_20069_() || this.mob.m_20077_()) && (this.mob.f_19862_ || !this.cachedDetectedGroundState && fluidHeight > (double)this.floatHeight) && this.mob.m_21187_().nextFloat() < 0.8f) {
            this.mob.m_21569_().m_24901_();
        }
    }

    public boolean detectGround(float height) {
        if (!this.mob.m_20077_() && this.mob.m_204036_(FluidTags.f_13131_) < (double)height) {
            float gap = (float)((double)height - this.mob.m_204036_(FluidTags.f_13131_));
            Vec3 gapVec = this.mob.m_20182_().m_82492_(0.0, (double)gap, 0.0);
            BlockPos gapPos = new BlockPos(gapVec);
            double delta = this.mob.f_19853_.m_8055_(gapPos).m_60812_((BlockGetter)this.mob.f_19853_, gapPos).m_83297_(Direction.Axis.Y);
            if (delta <= 0.0) {
                BlockPos gapPosBelow = gapPos.m_7495_();
                double lowerDelta = this.mob.f_19853_.m_8055_(gapPosBelow).m_60812_((BlockGetter)this.mob.f_19853_, gapPosBelow).m_83297_(Direction.Axis.Y);
                delta = lowerDelta - 1.0;
            }
            return delta > 0.0 && delta + (double)gapPos.m_123342_() - 1.0 < gapVec.f_82480_;
        }
        return false;
    }
}

