/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.entity.psyche;

import bottomtextdanny.braincell.mod.entity.psyche.Psyche;
import bottomtextdanny.braincell.mod.world.entity_utilities.PsycheEntity;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import java.util.SplittableRandom;
import javax.annotation.Nullable;
import net.minecraft.world.entity.PathfinderMob;

public abstract class Action<E extends PathfinderMob> {
    protected static final SplittableRandom UNSAFE_RANDOM = new SplittableRandom();
    protected static final Random RANDOM = new Random();
    private final List<Integer> modules;
    @Nullable
    private List<Integer> blockOtherModules;
    protected E mob;
    private final Psyche<E> psyche;
    protected int ticksPassed;
    private boolean active;
    private int lastUpdatedActiveState;
    private boolean running;
    private int moduleRunningOn;

    public Action(E mob) {
        this.mob = mob;
        this.psyche = ((PsycheEntity)mob).getPsyche();
        this.modules = Lists.newArrayList();
    }

    public boolean active() {
        if (this.lastUpdatedActiveState != ((PathfinderMob)this.mob).f_19797_) {
            this.lastUpdatedActiveState = ((PathfinderMob)this.mob).f_19797_;
            this.active = this.activeParameters();
        }
        return this.active;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean activeParameters() {
        if (this.psyche.isModuleDeactivated(this.moduleRunningOn)) return false;
        if (!this.modules.stream().noneMatch(this.psyche::isModuleDeactivated)) return false;
        return true;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean tryStart(int module) {
        this.moduleRunningOn = module;
        if (this.canStart()) {
            this.running = true;
            this.start();
            return true;
        }
        return false;
    }

    protected void start() {
    }

    public final void coreUpdate() {
        if (this.active()) {
            ++this.ticksPassed;
            if (this.blockOtherModules != null) {
                this.blockOtherModules.forEach(this.psyche::blockModule);
            }
            this.update();
        }
    }

    protected void update() {
    }

    public boolean shouldKeepGoing() {
        return false;
    }

    public boolean canStart() {
        return true;
    }

    public void onEnd() {
        this.ticksPassed = 0;
        this.running = false;
        this.moduleRunningOn = -1;
    }

    public boolean cancelNext() {
        return false;
    }

    public void addModule(int module) {
        this.modules.add(module);
    }

    public void addBlockedModule(int module) {
        if (this.blockOtherModules == null) {
            this.blockOtherModules = Lists.newArrayList();
        }
        this.blockOtherModules.add(module);
    }

    public Psyche<E> getPsyche() {
        return this.psyche;
    }

    protected int getTicksPassed() {
        return this.ticksPassed;
    }
}

