/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.entity.modules.variable;

import bottomtextdanny.braincell.mod._base.serialization.builtin.BuiltinSerializers;
import bottomtextdanny.braincell.mod.entity.modules.data_manager.BCDataManager;
import bottomtextdanny.braincell.mod.entity.modules.data_manager.BCDataManagerProvider;
import bottomtextdanny.braincell.mod.entity.modules.variable.Form;
import bottomtextdanny.braincell.mod.entity.modules.variable.StringedFormManager;
import bottomtextdanny.braincell.mod.entity.modules.variable.VariableModule;
import bottomtextdanny.braincell.mod.entity.serialization.EntityData;
import bottomtextdanny.braincell.mod.entity.serialization.EntityDataReference;
import bottomtextdanny.braincell.mod.entity.serialization.RawEntityDataReference;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class StringedVariableModule
extends VariableModule {
    public static final String NOT_UPDATED = "not_updated";
    public static final EntityDataReference<String> VARIANT_REF = BCDataManager.attribute(Entity.class, RawEntityDataReference.of(BuiltinSerializers.STRING, () -> "not_updated", "variant"));
    private final StringedFormManager formManager;
    private final EntityData<String> formKey;

    public StringedVariableModule(LivingEntity entity, StringedFormManager variantList) {
        super(entity);
        this.formManager = variantList;
        if (!(entity instanceof BCDataManagerProvider)) {
            throw new UnsupportedOperationException("StringedVariableModule needs the holder entity to inherit BCDataManager");
        }
        BCDataManagerProvider manager = (BCDataManagerProvider)entity;
        this.formKey = manager.bcDataManager().addSyncedData(EntityData.of(VARIANT_REF));
    }

    @Override
    public Form<?> getForm() {
        return this.formManager.getForm(this.formKey.get());
    }

    @Override
    public void setForm(Form<?> form) {
        this.formKey.set(this.formManager.getKey(form));
    }

    @Override
    public boolean hasFormTnput() {
        return this.formKey.get() != NOT_UPDATED;
    }
}

