/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.entity.modules.data_manager;

import bottomtextdanny.braincell.mod.entity.serialization.EntityData;
import bottomtextdanny.braincell.mod.entity.serialization.EntityDataReference;
import bottomtextdanny.braincell.mod.entity.serialization.RawEntityDataReference;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BCDataManager {
    public static final UnsupportedOperationException CANNOT_EXECUTE_NBT_OPERATIONS_ON_CLIENT_EX = new UnsupportedOperationException("World data does not support the execution of nbt operations on client.");
    public static final int REFERENCE_SPLIT = 8;
    public static final Map<Class<? extends Entity>, List<EntityDataReference<?>>> REFERENCES = new ConcurrentHashMap(8);
    private final List<EntityData<?>> syncedDataList;
    private final List<EntityData<?>> nonSyncedDataList;
    private final Entity provider;

    public BCDataManager(Entity provider) {
        this.provider = provider;
        this.syncedDataList = Lists.newArrayList();
        this.nonSyncedDataList = Lists.newArrayList();
    }

    public static <T> EntityDataReference<T> attribute(Class<? extends Entity> accessor, RawEntityDataReference<T> rawRef) {
        List<Object> list;
        if (REFERENCES.containsKey(accessor)) {
            list = REFERENCES.get(accessor);
        } else {
            list = Lists.newArrayList();
            REFERENCES.put(accessor, list);
        }
        int currSize = list.size();
        EntityDataReference<T> ref = rawRef.mark(accessor, currSize);
        list.add(ref);
        return ref;
    }

    public <T> EntityData<T> addNonSyncedData(EntityData<T> data) {
        this.nonSyncedDataList.add(data);
        return data;
    }

    public <T> EntityData<T> addSyncedData(EntityData<T> data) {
        this.syncedDataList.add(data);
        return data;
    }

    public void writeTag(CompoundTag tag) {
        Level level = this.provider.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            this.nonSyncedDataList.forEach(data -> data.writeToNBT(tag, (Level)level2));
            this.syncedDataList.forEach(data -> data.writeToNBT(tag, (Level)level2));
        }
    }

    public void readTag(CompoundTag tag) {
        this.nonSyncedDataList.forEach(data -> data.readFromNBT(tag, this.provider.f_19853_));
        this.syncedDataList.forEach(data -> data.readFromNBT(tag, this.provider.f_19853_));
    }

    public void writePacket(FriendlyByteBuf pct) {
        this.syncedDataList.forEach(data -> data.writeToPacketStream(pct, this.provider.f_19853_));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void readPacket(FriendlyByteBuf pct) {
        this.syncedDataList.forEach(data -> data.readFromPacketStream(pct, this.provider.f_19853_));
    }
}

