/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.entity.modules.animatable;

import bottomtextdanny.braincell.mod.entity.modules.animatable.Animation;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationGetter;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationHandler;
import bottomtextdanny.braincell.mod.entity.modules.animatable.BCAnimationToken;
import bottomtextdanny.braincell.mod.entity.modules.animatable.BaseAnimatableModule;
import bottomtextdanny.braincell.mod.entity.modules.animatable.LivingAnimatableProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class LivingAnimatableModule
extends BaseAnimatableModule<LivingAnimatableProvider> {
    private static final BCAnimationToken TOKEN = new BCAnimationToken();
    private final LivingEntity living;
    private final AnimationHandler<?> localHandler;
    private boolean deathHasBegun;

    public LivingAnimatableModule(LivingEntity entity, AnimationGetter manager) {
        super((Entity)entity, manager);
        this.localHandler = new AnimationHandler<LivingEntity>(entity);
        this.localHandler.setIndex(0, TOKEN);
        this.animationHandlerList().add(this.localHandler);
        this.living = entity;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.living.m_21223_() <= 0.0f) {
            Animation deathAnimation = ((LivingAnimatableProvider)this.provider).getDeathAnimation();
            if (!this.deathHasBegun) {
                if (deathAnimation != null && !this.living.f_19853_.f_46443_) {
                    this.localHandler.play(deathAnimation);
                }
                this.deathHasBegun = true;
                ((LivingAnimatableProvider)this.provider).onDeathAnimationStart();
            } else if (deathAnimation != null && this.localHandler.isPlaying(deathAnimation)) {
                this.tickDeathHook(deathAnimation.getDuration());
            } else {
                this.tickDeathHook(20);
            }
        }
    }

    public AnimationHandler<?> getLocalHandler() {
        return this.localHandler;
    }

    public void tickDeathHook(int time) {
        ++this.living.f_20919_;
        if (!this.living.f_19853_.f_46443_ && this.living.f_20919_ >= time) {
            ((LivingAnimatableProvider)this.provider).onDeathAnimationEnd();
            this.living.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public boolean deathHasBegun() {
        return this.deathHasBegun;
    }
}

