/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.entity.modules.animatable;

import bottomtextdanny.braincell.mod.entity.modules.EntityModule;
import bottomtextdanny.braincell.mod.entity.modules.animatable.Animation;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationGetter;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationHandler;
import bottomtextdanny.braincell.mod.entity.modules.animatable.BaseAnimatableProvider;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.Entity;

public abstract class BaseAnimatableModule<P extends BaseAnimatableProvider<?>>
extends EntityModule<Entity, P> {
    private final AnimationGetter animationsIndexed;
    private final ArrayList<AnimationHandler<?>> animationHandlersIndexed;

    public BaseAnimatableModule(Entity entity, AnimationGetter manager) {
        super(entity);
        this.animationsIndexed = manager;
        this.animationHandlersIndexed = Lists.newArrayList();
    }

    public void tick() {
        if (!this.entity.m_146910_()) {
            this.animationHandlerList().forEach(handler -> {
                Animation<?> animation = handler.getAnimation();
                if (animation != Animation.NULL) {
                    if (animation.goal(handler.getTick(), (AnimationHandler<?>)handler)) {
                        ((BaseAnimatableProvider)this.provider).animationEndCallout((AnimationHandler<?>)handler, animation);
                        handler.deactivate();
                    } else {
                        handler.update(animation.progressTick(handler.getTick(), (AnimationHandler<?>)handler));
                    }
                }
            });
        }
    }

    public AnimationGetter animationManager() {
        return this.animationsIndexed;
    }

    public List<AnimationHandler<?>> animationHandlerList() {
        return this.animationHandlersIndexed;
    }
}

