/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.entity.modules.animatable;

import bottomtextdanny.braincell.mod._base.BCStaticData;
import bottomtextdanny.braincell.mod.entity.modules.animatable.Animation;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationData;
import bottomtextdanny.braincell.mod.entity.modules.animatable.BCAnimationToken;
import bottomtextdanny.braincell.mod.network.stc.MSGEntityAnimation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class AnimationHandler<E extends Entity> {
    private int index;
    protected final E entity;
    protected AnimationData animationMetadata = AnimationData.NULL;
    protected Animation<?> animation = Animation.NULL;
    protected int prevTick;
    protected int tick;

    public AnimationHandler(E entity) {
        this.entity = entity;
    }

    public void play(Animation<?> animation) {
        if (!((Entity)this.entity).f_19853_.m_5776_()) {
            new MSGEntityAnimation(this.entity.m_142049_(), this.index, animation.getIndex()).sendTo(PacketDistributor.ALL.with(() -> null));
        }
        this.animation.onEnd(this);
        this.prevTick = 0;
        this.tick = 0;
        this.animation = animation;
        this.animationMetadata = (AnimationData)animation.dataForPlay().get();
        this.animation.onStart(this);
    }

    public void update(int tick) {
        this.prevTick = this.tick;
        this.tick = tick;
    }

    public void deactivate() {
        this.tick = 0;
        this.animation.onEnd(this);
        this.animation = Animation.NULL;
    }

    public void setIndex(int index, BCAnimationToken token) {
        if (token == null) {
            throw new IllegalArgumentException("Invalid token.");
        }
        this.index = index;
    }

    public Animation<?> getAnimation() {
        return this.animation;
    }

    public AnimationData getData() {
        return this.animationMetadata;
    }

    public int getIndex() {
        return this.index;
    }

    public int getTick() {
        return this.tick;
    }

    public E getEntity() {
        return this.entity;
    }

    public boolean isPlaying(Animation<?> animation) {
        return this.animation == animation;
    }

    public boolean isPlayingNull() {
        return this.animation == Animation.NULL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float linearProgress() {
        return (float)this.tick + BCStaticData.partialTick();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float dynamicProgress() {
        return Mth.m_14179_((float)BCStaticData.partialTick(), (float)this.prevTick, (float)this.tick);
    }
}

