/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.entity.modules.animatable;

import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationData;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationGetter;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationHandler;
import bottomtextdanny.braincell.mod.entity.modules.animatable.BCAnimationToken;
import java.util.function.Supplier;

public interface Animation<T extends AnimationData>
extends AnimationGetter {
    public static final NullAnimation NULL = new NullAnimation();

    public Supplier<T> dataForPlay();

    public int progressTick(int var1, AnimationHandler<?> var2);

    public boolean goal(int var1, AnimationHandler<?> var2);

    default public void onStart(AnimationHandler<?> handler) {
    }

    default public void onEnd(AnimationHandler<?> handler) {
    }

    @Override
    default public int size() {
        return 1;
    }

    @Override
    default public Animation<?> getAnimation(int index) {
        return this;
    }

    public int getDuration();

    public int getIndex();

    public void setIndex(int var1, BCAnimationToken var2);

    public boolean isFrom(int var1);

    default public T getData(AnimationHandler<?> handler) {
        return (T)(handler.isPlaying(this) ? handler.getData() : null);
    }

    public static class NullAnimation
    implements Animation<AnimationData> {
        @Override
        public Supplier<AnimationData> dataForPlay() {
            return () -> AnimationData.NULL;
        }

        @Override
        public int progressTick(int duration, AnimationHandler<?> data) {
            return 0;
        }

        @Override
        public boolean goal(int prog, AnimationHandler<?> data) {
            return false;
        }

        @Override
        public int getDuration() {
            return 0;
        }

        @Override
        public boolean isFrom(int identifier) {
            return false;
        }

        @Override
        public int getIndex() {
            return -1;
        }

        @Override
        public void setIndex(int index, BCAnimationToken token) {
        }
    }
}

