/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.entity.modules.animatable;

import bottomtextdanny.braincell.mod.entity.modules.animatable.Animation;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationData;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationHandler;
import bottomtextdanny.braincell.mod.entity.modules.animatable.BCAnimationToken;
import bottomtextdanny.braincell.mod.entity.modules.animatable.SimpleAnimation;

public abstract class AbstractAnimation<T extends AnimationData>
implements Animation<T> {
    public static final int NO_IDENTIFIER = -1;
    private int auxId = -1;
    private int index = 0;
    private final int tickDuration;

    public AbstractAnimation(int duration) {
        this.tickDuration = duration;
    }

    public <A extends SimpleAnimation> A identifier(int identifier) {
        this.auxId = identifier;
        return (A)((SimpleAnimation)this);
    }

    @Override
    public boolean isFrom(int identifier) {
        return this.auxId == identifier;
    }

    @Override
    public int progressTick(int progress, AnimationHandler<?> handler) {
        return progress + 1;
    }

    @Override
    public boolean goal(int progression, AnimationHandler<?> handler) {
        return progression > this.tickDuration;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index, BCAnimationToken token) {
        if (token == null) {
            throw new IllegalStateException("Invalid token.");
        }
        this.index = index;
    }

    @Override
    public int getDuration() {
        return this.tickDuration;
    }
}

