/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.capability.player.accessory;

import bottomtextdanny.braincell.base.pair.Pair;
import bottomtextdanny.braincell.mod.capability.player.accessory.AccessoryKey;
import bottomtextdanny.braincell.mod.capability.player.accessory.IAccessory;
import bottomtextdanny.braincell.mod.capability.player.accessory.MiniAttribute;
import bottomtextdanny.braincell.mod.capability.player.accessory.ModifierType;
import java.util.List;

public interface AttributeModifierAccessory
extends IAccessory {
    public void populateModifierData(List<Pair<ModifierType, Double>> var1, List<Pair<MiniAttribute, Float>> var2);

    default public double getModifierBase(ModifierType modifierType) {
        return AccessoryKey.getAttributeData().get(this.getKey()).getBaseValue(modifierType);
    }

    default public boolean isModifierActive(ModifierType modifierType) {
        return AccessoryKey.getAttributeData().get(this.getKey()).containsModifier(modifierType);
    }

    default public float getLesserModifierBase(MiniAttribute modifierType) {
        return AccessoryKey.getAttributeData().get(this.getKey()).getBaseValue(modifierType);
    }

    default public boolean isLesserModifierActive(MiniAttribute modifierType) {
        return AccessoryKey.getAttributeData().get(this.getKey()).containsLesserModifier(modifierType);
    }

    default public double getFinalSpeedMultiplier() {
        return this.getModifierBase(ModifierType.MOVEMENT_SPEED_MLT) / 100.0 + 1.0;
    }

    default public double getFinalAttackSpeedAddition() {
        return this.getModifierBase(ModifierType.ATTACK_SPEED_ADD);
    }

    default public double getFinalAttackDamageAddition() {
        return this.getModifierBase(ModifierType.ATTACK_DAMAGE_ADD);
    }

    default public double getFinalAttackKnockbackAddition() {
        return this.getModifierBase(ModifierType.ATTACK_KNOCKBACK_ADD);
    }

    default public double getFinalKnockbackResistanceMultiplier() {
        return this.getModifierBase(ModifierType.KNOCKBACK_RESISTANCE_MLT);
    }

    default public double getFinalKnockbackResistanceAddition() {
        return this.getModifierBase(ModifierType.KNOCKBACK_RESISTANCE_ADD);
    }

    default public double getFinalArmorAddition() {
        return this.getModifierBase(ModifierType.ARMOR_ADD);
    }

    default public double getFinalLuckAddition() {
        return this.getModifierBase(ModifierType.LUCK_ADD);
    }

    default public float getFinalLesserAttributeValue(MiniAttribute attribute) {
        return this.getLesserModifierBase(attribute);
    }

    default public List<ModifierType> modifiedAttributes() {
        return AccessoryKey.getAttributeData().get(this.getKey()).modifierIterable;
    }
}

