/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.capability.player.accessory;

import bottomtextdanny.braincell.Braincell;
import bottomtextdanny.braincell.mod.capability.player.accessory.AccessoryAttributeModifierData;
import bottomtextdanny.braincell.mod.capability.player.accessory.AccessoryFactory;
import bottomtextdanny.braincell.mod.capability.player.accessory.AttributeModifierAccessory;
import bottomtextdanny.braincell.mod.capability.player.accessory.BCAccessoryKeys;
import bottomtextdanny.braincell.mod.capability.player.accessory.EmptyAccessoryKeyCollectorEvent;
import bottomtextdanny.braincell.mod.capability.player.accessory.IAccessory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class AccessoryKey<E extends IAccessory> {
    private static Map<AccessoryKey<?>, AccessoryAttributeModifierData> ATTRIBUTE_DATA;
    private static final ObjectOpenHashSet<AccessoryKey<?>> EMPTY_LOOKUP;
    private static List<AccessoryKey<?>> ACCESSORIES_BY_ID;
    private static Map<ResourceLocation, AccessoryKey<?>> ACCESSORIES_BY_LOCATION;
    private static boolean initialized;
    private final ResourceLocation key;
    private final AccessoryFactory<E> accessoryFactory;
    private int id;

    private AccessoryKey(AccessoryFactory<E> accessoryFactory, ResourceLocation key) {
        this.accessoryFactory = accessoryFactory;
        this.key = key;
    }

    public static <E extends IAccessory> AccessoryKey<E> createKey(ResourceLocation location, AccessoryFactory<E> supplier) {
        if (Braincell.common().hasPassedInitialization()) {
            throw new UnsupportedOperationException("Can't create new accessory keys after mod initialization.");
        }
        AccessoryKey<E> key = new AccessoryKey<E>(supplier, location);
        key.id = ACCESSORIES_BY_ID.size();
        ACCESSORIES_BY_ID.add(key);
        ACCESSORIES_BY_LOCATION.put(location, key);
        return key;
    }

    public ResourceLocation getLocation() {
        return this.key;
    }

    public int getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessoryKey that = (AccessoryKey)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }

    public E create(Player player) {
        return this.accessoryFactory.make(this, player);
    }

    public static List<AccessoryKey<?>> getAccessoriesById() {
        return ACCESSORIES_BY_ID;
    }

    public static Map<ResourceLocation, AccessoryKey<?>> getAccessoriesByLocation() {
        return ACCESSORIES_BY_LOCATION;
    }

    public static Map<AccessoryKey<?>, AccessoryAttributeModifierData> getAttributeData() {
        return ATTRIBUTE_DATA;
    }

    public static boolean isEmpty(AccessoryKey<?> key) {
        return EMPTY_LOOKUP.contains(key);
    }

    public static void build() {
        if (initialized) {
            throw new UnsupportedOperationException("Accessories are already initialized!");
        }
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> {
            EmptyAccessoryKeyCollectorEvent collectorEvent = new EmptyAccessoryKeyCollectorEvent();
            MinecraftForge.EVENT_BUS.post((Event)collectorEvent);
            EMPTY_LOOKUP.add(BCAccessoryKeys.EMPTY);
            EMPTY_LOOKUP.add(BCAccessoryKeys.STACK_EMPTY);
            EMPTY_LOOKUP.addAll(collectorEvent.getCollection());
        });
        ImmutableMap.Builder dataBuilder = ImmutableMap.builder();
        ACCESSORIES_BY_ID = ImmutableList.copyOf(ACCESSORIES_BY_ID);
        ACCESSORIES_BY_LOCATION = ImmutableMap.copyOf(ACCESSORIES_BY_LOCATION);
        initialized = true;
        ACCESSORIES_BY_ID.forEach(key -> {
            Object patt4104$temp = key.create(null);
            if (patt4104$temp instanceof AttributeModifierAccessory) {
                AttributeModifierAccessory accessory = (AttributeModifierAccessory)patt4104$temp;
                LinkedList modifierList = Lists.newLinkedList();
                LinkedList lesserModifierList = Lists.newLinkedList();
                accessory.populateModifierData(modifierList, lesserModifierList);
                AccessoryAttributeModifierData data = AccessoryAttributeModifierData.create(modifierList, lesserModifierList);
                dataBuilder.put(key, (Object)data);
            }
        });
        ATTRIBUTE_DATA = dataBuilder.build();
    }

    static {
        EMPTY_LOOKUP = new ObjectOpenHashSet(16);
        ACCESSORIES_BY_ID = Lists.newLinkedList();
        ACCESSORIES_BY_LOCATION = Maps.newHashMap();
    }
}

