/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.capability.player;

import bottomtextdanny.braincell.base.ObjectFetcher;
import bottomtextdanny.braincell.base.SparedHashCollection;
import bottomtextdanny.braincell.base.function.Clearable;
import bottomtextdanny.braincell.mod._base.BCEvaluations;
import bottomtextdanny.braincell.mod.capability.CapabilityModule;
import bottomtextdanny.braincell.mod.capability.player.BCPlayerCapability;
import bottomtextdanny.braincell.mod.capability.player.accessory.AccessoryKey;
import bottomtextdanny.braincell.mod.capability.player.accessory.AllAccessoryCollectorEvent;
import bottomtextdanny.braincell.mod.capability.player.accessory.AttributeModifierAccessory;
import bottomtextdanny.braincell.mod.capability.player.accessory.HandAccessories;
import bottomtextdanny.braincell.mod.capability.player.accessory.IAccessory;
import bottomtextdanny.braincell.mod.capability.player.accessory.IJumpQueuerAccessory;
import bottomtextdanny.braincell.mod.capability.player.accessory.IQueuedJump;
import bottomtextdanny.braincell.mod.capability.player.accessory.MiniAttribute;
import bottomtextdanny.braincell.mod.capability.player.accessory.ModifierType;
import bottomtextdanny.braincell.mod.capability.player.accessory.StackAccSoftSave;
import bottomtextdanny.braincell.mod.capability.player.accessory.StackAccessory;
import bottomtextdanny.braincell.mod.capability.player.accessory.StackAccessoryProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Options;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class BCAccessoryModule
extends CapabilityModule<Player, BCPlayerCapability> {
    public static final int STACK_ACCESSORY_CACHE_ROW = 10;
    private final float[] lesserAttributes = (float[])Util.m_137537_(() -> {
        float[] attributes = new float[MiniAttribute.size()];
        for (int i = 0; i < attributes.length; ++i) {
            attributes[i] = MiniAttribute.getModifierByIndex((int)i).baseValue;
        }
        return attributes;
    });
    private final Clearable<List<IAccessory>> allAccessoryList;
    private final List<AttributeModifierAccessory> modifierAccessoryList = Lists.newLinkedList();
    private final EnumMap<ModifierType, LinkedList<AttributeModifierAccessory>> accessoryAttributeModifiers;
    private final Map<Class<? extends IAccessory>, IAccessory> currentAccessoryTypes;
    private final TreeSet<IQueuedJump> jumps;
    private final SparedHashCollection<AccessoryKey<?>, Object[]> stackAccessoryCache;
    private final HandAccessories handManager = new HandAccessories();
    public boolean goodOnGround;

    public BCAccessoryModule(BCPlayerCapability capability) {
        super("accessories", capability);
        this.allAccessoryList = Clearable.of(() -> {
            ImmutableList.Builder list = ImmutableList.builder();
            list.add((Object)this.handManager.getMain());
            list.add((Object)this.handManager.getOff());
            AllAccessoryCollectorEvent event = new AllAccessoryCollectorEvent((ImmutableList.Builder<IAccessory>)list, (Player)this.getHolder());
            MinecraftForge.EVENT_BUS.post((Event)event);
            return list.build();
        });
        this.accessoryAttributeModifiers = new EnumMap(ModifierType.class);
        this.currentAccessoryTypes = Maps.newIdentityHashMap();
        this.jumps = new TreeSet<IQueuedJump>(Comparator.comparingInt(right -> right.priority().ordinal()));
        this.stackAccessoryCache = new SparedHashCollection(10);
    }

    public void tick() {
        this.allAccessoryList.clear();
        this.allAccessoryList.get().forEach(IAccessory::tick);
        if (!((Player)this.getHolder()).f_19853_.f_46443_) {
            List<MiniAttribute> miniValues = MiniAttribute.values();
            for (MiniAttribute miniValue : miniValues) {
                this.resetLesserAttribute(miniValue);
                this.modifyLesserAttribute(miniValue, BCEvaluations.LESSER_MODIFIER_VALUE.test(this, miniValue).floatValue());
            }
            this.replaceAttributeModifier(ModifierType.ATTACK_DAMAGE_ADD, "Accessory attack damage addition", BCEvaluations.MODIFIER_VALUE.test(this, ModifierType.ATTACK_DAMAGE_ADD));
            this.replaceAttributeModifier(ModifierType.ATTACK_SPEED_ADD, "Accessory attack speed addition", BCEvaluations.MODIFIER_VALUE.test(this, ModifierType.ATTACK_SPEED_ADD));
            this.replaceAttributeModifier(ModifierType.ATTACK_KNOCKBACK_ADD, "Accessory attack knockback addition", BCEvaluations.MODIFIER_VALUE.test(this, ModifierType.ATTACK_KNOCKBACK_ADD));
            this.replaceAttributeModifier(ModifierType.KNOCKBACK_RESISTANCE_ADD, "Accessory knockback resistance addition", BCEvaluations.MODIFIER_VALUE.test(this, ModifierType.KNOCKBACK_RESISTANCE_ADD));
            this.replaceAttributeModifier(ModifierType.ARMOR_ADD, "Accessory armor addition", BCEvaluations.MODIFIER_VALUE.test(this, ModifierType.ARMOR_ADD));
            this.replaceAttributeModifier(ModifierType.LUCK_ADD, "Accessory luck addition", BCEvaluations.MODIFIER_VALUE.test(this, ModifierType.LUCK_ADD));
            this.replaceAttributeModifier(ModifierType.MOVEMENT_SPEED_MLT, "Accessory speed multiplier", BCEvaluations.MODIFIER_VALUE.test(this, ModifierType.MOVEMENT_SPEED_MLT));
            this.replaceAttributeModifier(ModifierType.KNOCKBACK_RESISTANCE_MLT, "Accessory knockback resistance multiplier", BCEvaluations.MODIFIER_VALUE.test(this, ModifierType.KNOCKBACK_RESISTANCE_MLT));
        }
        this.handleItemstackAccessories();
    }

    public void handleItemstackAccessories() {
        this.handManager.updatePrevious();
        this.handleHand(InteractionHand.MAIN_HAND);
        this.handleHand(InteractionHand.OFF_HAND);
    }

    public void handleHand(InteractionHand handSide) {
        int handId = handSide.ordinal();
        StackAccessory accessory = (StackAccessory)((Function)HandAccessories.ACCESSORY_FOR_HAND.get(handId)).apply(this);
        StackAccessory accessoryO = (StackAccessory)((Function)HandAccessories.ACCESSORYO_FOR_HAND.get(handId)).apply(this);
        ItemStack itemStack = ((Player)this.getHolder()).m_21120_(handSide);
        if (!(itemStack.m_41720_() instanceof StackAccessoryProvider)) {
            if (accessoryO instanceof StackAccSoftSave) {
                StackAccSoftSave softSave = (StackAccSoftSave)((Object)accessoryO);
                this.stackAccessoryCache.insert(accessoryO.getKey(), softSave.save());
            }
            ((BiConsumer)HandAccessories.SET_BY_HAND.get(handId)).accept(this, StackAccessory.EMPTY);
        } else if (accessory.getItem() != itemStack.m_41720_()) {
            this.onAccessoryRemoval(accessory);
            StackAccessoryProvider provider = (StackAccessoryProvider)itemStack.m_41720_();
            StackAccessory newAccessory = provider.getKey().create((Player)this.getHolder());
            newAccessory.prepare(itemStack, handSide);
            this.onAccessoryAddition(newAccessory);
            ((BiConsumer)HandAccessories.SET_BY_HAND.get(handId)).accept(this, newAccessory);
            if (accessory instanceof StackAccSoftSave) {
                StackAccSoftSave softSave = (StackAccSoftSave)((Object)accessory);
                this.stackAccessoryCache.insert(accessoryO.getKey(), softSave.save());
            }
            if (newAccessory instanceof StackAccSoftSave) {
                StackAccSoftSave saveAcc = (StackAccSoftSave)((Object)newAccessory);
                Object[] fetchedSave = this.stackAccessoryCache.look(newAccessory.getKey());
                if (fetchedSave != null) {
                    saveAcc.retrieve(ObjectFetcher.of(fetchedSave));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClientKeybinds(Options settings) {
        this.allAccessoryList.get().forEach(accessory -> accessory.keyHandler(settings));
    }

    public final void replaceAttributeModifier(ModifierType modifierType, String name, double newValue) {
        Attribute attribute = modifierType.attribute.get();
        UUID uuid = modifierType.uuid;
        AttributeInstance attributeInst = ((Player)this.getHolder()).m_21051_(attribute);
        if (attributeInst != null) {
            if (attributeInst.m_22111_(uuid) != null) {
                if (attributeInst.m_22111_(uuid).m_22218_() != newValue) {
                    attributeInst.m_22120_(uuid);
                    attributeInst.m_22118_(new AttributeModifier(uuid, name, newValue, modifierType.operation));
                }
            } else {
                attributeInst.m_22118_(new AttributeModifier(uuid, name, newValue, modifierType.operation));
            }
        }
    }

    private void modifyLesserAttribute(MiniAttribute attribute, float factor) {
        int n = attribute.getIndex();
        this.lesserAttributes[n] = this.lesserAttributes[n] + factor;
        this.lesserAttributes[attribute.getIndex()] = Mth.m_14036_((float)this.lesserAttributes[attribute.getIndex()], (float)attribute.clampMin, (float)attribute.clampMax);
    }

    private void resetLesserAttribute(MiniAttribute attribute) {
        this.lesserAttributes[attribute.getIndex()] = attribute.baseValue;
    }

    public float[] getLesserAttributes() {
        return this.lesserAttributes;
    }

    public List<AttributeModifierAccessory> getOrCreateAccessoryAttributeModifiers(ModifierType attributeModifierTarget) {
        if (!this.accessoryAttributeModifiers.containsKey((Object)attributeModifierTarget)) {
            this.accessoryAttributeModifiers.put(attributeModifierTarget, Lists.newLinkedList());
        }
        return this.accessoryAttributeModifiers.get((Object)attributeModifierTarget);
    }

    public void addAccessoryAttributeModifier(ModifierType attributeModifierTarget, AttributeModifierAccessory accessory) {
        if (!this.accessoryAttributeModifiers.containsKey((Object)attributeModifierTarget)) {
            this.accessoryAttributeModifiers.put(attributeModifierTarget, Lists.newLinkedList());
        }
        this.accessoryAttributeModifiers.get((Object)attributeModifierTarget).add(accessory);
    }

    public void deleteAccessoryAttributeModifier(ModifierType attributeModifierTarget, AttributeModifierAccessory accessory) {
        this.accessoryAttributeModifiers.get((Object)attributeModifierTarget).remove(accessory);
    }

    public void addToCurrentAccessorySet(IAccessory accessory) {
        if (!(accessory instanceof StackAccessory)) {
            this.currentAccessoryTypes.putIfAbsent(accessory.getClass(), accessory);
        }
    }

    public void deleteFromCurrentAccessorySet(Class<? extends IAccessory> accessoryClazz) {
        this.currentAccessoryTypes.remove(accessoryClazz);
    }

    public boolean isAccessoryTypeCurrent(Class<? extends IAccessory> accessoryClazz) {
        return this.currentAccessoryTypes.containsKey(accessoryClazz);
    }

    public void onAccessoryAddition(IAccessory accessory) {
        this.addToCurrentAccessorySet(accessory);
        if (accessory instanceof IJumpQueuerAccessory) {
            IJumpQueuerAccessory jumpQueuer = (IJumpQueuerAccessory)accessory;
            Collections.addAll(this.jumps, jumpQueuer.provideJumps());
        }
        if (accessory instanceof AttributeModifierAccessory) {
            AttributeModifierAccessory attributeModifier = (AttributeModifierAccessory)accessory;
            List<ModifierType> attributes = attributeModifier.modifiedAttributes();
            for (ModifierType attribute : attributes) {
                this.addAccessoryAttributeModifier(attribute, attributeModifier);
            }
            this.modifierAccessoryList.add(attributeModifier);
        }
    }

    public void onAccessoryRemoval(IAccessory accessory) {
        this.deleteFromCurrentAccessorySet(accessory.getClass());
        if (accessory instanceof IJumpQueuerAccessory) {
            IJumpQueuerAccessory jumpQueuer = (IJumpQueuerAccessory)accessory;
            for (IQueuedJump iQueuedJump : jumpQueuer.provideJumps()) {
                this.jumps.remove(iQueuedJump);
            }
        }
        if (accessory instanceof AttributeModifierAccessory) {
            AttributeModifierAccessory attributeModifier = (AttributeModifierAccessory)accessory;
            List<ModifierType> attributes = attributeModifier.modifiedAttributes();
            for (ModifierType attribute : attributes) {
                this.deleteAccessoryAttributeModifier(attribute, attributeModifier);
            }
            this.modifierAccessoryList.remove(attributeModifier);
        }
    }

    @Nullable
    public <A extends IAccessory> A getAccessoryByType(Class<A> accessory) {
        if (this.currentAccessoryTypes.containsKey(accessory)) {
            return (A)this.currentAccessoryTypes.get(accessory);
        }
        return null;
    }

    public float getLesserModifier(MiniAttribute attribute) {
        return this.lesserAttributes[attribute.getIndex()];
    }

    public TreeSet<IQueuedJump> getJumpSet() {
        return this.jumps;
    }

    public List<AttributeModifierAccessory> getAttributeModifierAccessoryList() {
        return this.modifierAccessoryList;
    }

    public List<IAccessory> getAllAccessoryList() {
        return this.allAccessoryList.get();
    }

    public HandAccessories getHandManager() {
        return this.handManager;
    }

    @Override
    public void serializeNBT(CompoundTag nbt) {
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
    }
}

