/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.capability.level.speck;

import bottomtextdanny.braincell.mod.capability.CapabilityHelper;
import bottomtextdanny.braincell.mod.capability.level.BCLevelCapability;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Speck {
    private static final int MAX_UNLOADED_TICKS = 400;
    protected final Level level;
    private Vec3 position = Vec3.f_82478_;
    public double xo;
    public double yo;
    public double zo;
    private int areaUnloadedTicks;
    private int ticksExisted;
    private boolean removed;

    public Speck(Level level) {
        this.level = level;
    }

    public final void baseTick() {
        ++this.ticksExisted;
        if (!this.level.m_46805_(this.getBlockPosition())) {
            ++this.areaUnloadedTicks;
            if (this.areaUnloadedTicks > 400) {
                this.remove();
            }
        } else {
            this.areaUnloadedTicks = 0;
        }
        this.xo = this.position.f_82479_;
        this.yo = this.position.f_82480_;
        this.zo = this.position.f_82481_;
        this.tick();
    }

    protected void tick() {
    }

    public void remove() {
        this.removed = true;
    }

    public void addToLevel() {
        BCLevelCapability capability = (BCLevelCapability)CapabilityHelper.get(this.level, BCLevelCapability.TOKEN);
        capability.getSpeckManager().addSpeck(this);
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public BlockPos getBlockPosition() {
        return new BlockPos(this.position);
    }

    public void setPosition(Vec3 position) {
        this.position = position;
    }

    public double getPosX() {
        return this.position.f_82479_;
    }

    public double getPosY() {
        return this.position.f_82480_;
    }

    public double getPosZ() {
        return this.position.f_82481_;
    }

    public int getAreaUnloadedTicks() {
        return this.areaUnloadedTicks;
    }

    public int getTicksExisted() {
        return this.ticksExisted;
    }
}

