/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.capability.level;

import bottomtextdanny.braincell.base.BCLerp;
import bottomtextdanny.braincell.mod._base.BCStaticData;
import bottomtextdanny.braincell.mod.capability.CapabilityModule;
import bottomtextdanny.braincell.mod.capability.level.BCLevelCapability;
import bottomtextdanny.braincell.mod.capability.level.speck.RenderableSpeck;
import bottomtextdanny.braincell.mod.capability.level.speck.Speck;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpeckManagerModule
extends CapabilityModule<Level, BCLevelCapability> {
    private final List<Speck> queuedSpecks = Lists.newLinkedList();
    private final List<Speck> specks = Lists.newLinkedList();

    public SpeckManagerModule(BCLevelCapability capability) {
        super("specks", capability);
    }

    public void tick() {
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        Iterator<Speck> newSpecks = this.queuedSpecks.iterator();
        while (newSpecks.hasNext()) {
            Speck newSpeck = newSpecks.next();
            this.specks.add(newSpeck);
            newSpecks.remove();
        }
        this.specks.removeIf(speck -> {
            speck.baseTick();
            return speck.isRemoved();
        });
    }

    public void render(PoseStack stack, MultiBufferSource buffer) {
        float partialTick = BCStaticData.partialTick();
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        double camX = camera.m_90583_().f_82479_;
        double camY = camera.m_90583_().f_82480_;
        double camZ = camera.m_90583_().f_82481_;
        stack.m_85836_();
        stack.m_85837_(-camX, -camY, -camZ);
        for (Speck speck : this.specks) {
            RenderableSpeck renderable;
            if (!(speck instanceof RenderableSpeck) || !(renderable = (RenderableSpeck)((Object)speck)).shouldRender()) continue;
            double easedX = BCLerp.get((double)partialTick, speck.xo, speck.getPosX());
            double easedY = BCLerp.get((double)partialTick, speck.yo, speck.getPosY());
            double easedZ = BCLerp.get((double)partialTick, speck.zo, speck.getPosZ());
            stack.m_85836_();
            stack.m_85837_(easedX, easedY, easedZ);
            renderable.render((float)easedX, (float)easedY, (float)easedZ, stack, buffer, partialTick);
            stack.m_85849_();
        }
        stack.m_85849_();
    }

    public boolean addSpeck(Speck speck) {
        return this.queuedSpecks.add(speck);
    }

    @Override
    public void serializeNBT(CompoundTag nbt) {
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
    }
}

