/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.capability;

import bottomtextdanny.braincell.mod.capability.CapabilityModule;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.antlr.v4.runtime.misc.NotNull;

public abstract class CapabilityWrap<C extends CapabilityWrap<C, T>, T>
implements INBTSerializable<CompoundTag>,
ICapabilityProvider {
    private final ImmutableList<CapabilityModule<T, C>> moduleImmutableList;
    private final T holder;

    public CapabilityWrap(T holder) {
        this.holder = holder;
        ImmutableList.Builder moduleListBuilder = ImmutableList.builder();
        this.populateModuleList(moduleListBuilder);
        ImmutableList modules = moduleListBuilder.build();
        this.moduleImmutableList = modules.isEmpty() ? ImmutableList.of() : modules;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (!this.moduleImmutableList.isEmpty()) {
            this.moduleImmutableList.forEach(module -> module.serializeNBT(tag));
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (!this.moduleImmutableList.isEmpty()) {
            this.moduleImmutableList.forEach(module -> module.deserializeNBT(nbt));
        }
    }

    protected abstract void populateModuleList(ImmutableList.Builder<CapabilityModule<T, C>> var1);

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap == this.getToken() ? LazyOptional.of(() -> this).cast() : LazyOptional.empty();
    }

    public <CAP extends CapabilityModule<T, C>> CAP getModule(Class<CAP> clazz) {
        return (CAP)((CapabilityModule)null);
    }

    public T getHolder() {
        return this.holder;
    }

    protected abstract Capability<?> getToken();
}

