/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._mod.common_sided;

import bottomtextdanny.braincell.mod._base.serialization.SerializerMark;
import bottomtextdanny.braincell.mod._base.serialization.builtin.BlockPosSerializer;
import bottomtextdanny.braincell.mod._base.serialization.builtin.BooleanSerializer;
import bottomtextdanny.braincell.mod._base.serialization.builtin.BuiltinSerializers;
import bottomtextdanny.braincell.mod._base.serialization.builtin.ByteSerializer;
import bottomtextdanny.braincell.mod._base.serialization.builtin.DirectionSerializer;
import bottomtextdanny.braincell.mod._base.serialization.builtin.DoubleSerializer;
import bottomtextdanny.braincell.mod._base.serialization.builtin.FloatSerializer;
import bottomtextdanny.braincell.mod._base.serialization.builtin.IntegerSerializer;
import bottomtextdanny.braincell.mod._base.serialization.builtin.ItemSerializer;
import bottomtextdanny.braincell.mod._base.serialization.builtin.ItemStackSerializer;
import bottomtextdanny.braincell.mod._base.serialization.builtin.LongSerializer;
import bottomtextdanny.braincell.mod._base.serialization.builtin.ParticleOptionsSerializer;
import bottomtextdanny.braincell.mod._base.serialization.builtin.ResourceLocationSerializer;
import bottomtextdanny.braincell.mod._base.serialization.builtin.ShortSerializer;
import bottomtextdanny.braincell.mod._base.serialization.builtin.StringSerializer;
import bottomtextdanny.braincell.mod._base.serialization.builtin.UUIDSerializer;
import bottomtextdanny.braincell.mod._base.serialization.builtin.Vec2Serializer;
import bottomtextdanny.braincell.mod._base.serialization.builtin.Vec3Serializer;
import bottomtextdanny.braincell.mod._base.serialization.builtin.world.EntityReferenceSerializer;
import bottomtextdanny.braincell.mod._base.serialization.builtin.world.EntitySerializer;
import bottomtextdanny.braincell.mod._mod.common_sided.events.SerializerLookupBuildingEvent;
import bottomtextdanny.braincell.mod.serialization.BCSerializers;
import bottomtextdanny.braincell.mod.serialization.IntSchedulerSerializer;
import bottomtextdanny.braincell.mod.serialization.RangedIntSchedulerSerializer;
import bottomtextdanny.braincell.mod.serialization.entity.VariableIntSchedulerSerializer;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.mutable.MutableInt;

public interface SerializerLookup {
    public int getIdFromSerializer(SerializerMark<?> var1);

    public SerializerMark<?> getSerializerFromId(int var1);

    public static SerializerLookup createUnbuilt() {
        return new NotBuilt();
    }

    public static class NotBuilt
    implements SerializerLookup {
        public static final UnsupportedOperationException UNBUILT_LOOKUP_EX = new UnsupportedOperationException("Cannot execute search operations on unbuilt lookup.");
        private final ImmutableMap.Builder<ResourceLocation, SerializerMark<?>> serializerLookupBuilder = ImmutableMap.builder();
        private final ImmutableBiMap.Builder<Integer, SerializerMark<?>> idLookupBuilder = ImmutableBiMap.builder();

        private NotBuilt() {
        }

        private static void bootstrap(ImmutableMap.Builder<ResourceLocation, SerializerMark<?>> serializerLookupBuilder, ImmutableBiMap.Builder<Integer, SerializerMark<?>> idLookupBuilder, MutableInt idCounter) {
            serializerLookupBuilder.put((Object)BooleanSerializer.REF, (Object)BuiltinSerializers.BOOLEAN);
            idLookupBuilder.put((Object)idCounter.getAndIncrement(), (Object)BuiltinSerializers.BOOLEAN);
            serializerLookupBuilder.put((Object)ByteSerializer.REF, (Object)BuiltinSerializers.BYTE);
            idLookupBuilder.put((Object)idCounter.getAndIncrement(), (Object)BuiltinSerializers.BYTE);
            serializerLookupBuilder.put((Object)ShortSerializer.REF, (Object)BuiltinSerializers.SHORT);
            idLookupBuilder.put((Object)idCounter.getAndIncrement(), (Object)BuiltinSerializers.SHORT);
            serializerLookupBuilder.put((Object)IntegerSerializer.REF, (Object)BuiltinSerializers.INTEGER);
            idLookupBuilder.put((Object)idCounter.getAndIncrement(), (Object)BuiltinSerializers.INTEGER);
            serializerLookupBuilder.put((Object)FloatSerializer.REF, (Object)BuiltinSerializers.FLOAT);
            idLookupBuilder.put((Object)idCounter.getAndIncrement(), (Object)BuiltinSerializers.FLOAT);
            serializerLookupBuilder.put((Object)DoubleSerializer.REF, (Object)BuiltinSerializers.DOUBLE);
            idLookupBuilder.put((Object)idCounter.getAndIncrement(), (Object)BuiltinSerializers.DOUBLE);
            serializerLookupBuilder.put((Object)LongSerializer.REF, (Object)BuiltinSerializers.LONG);
            idLookupBuilder.put((Object)idCounter.getAndIncrement(), (Object)BuiltinSerializers.LONG);
            serializerLookupBuilder.put((Object)StringSerializer.REF, (Object)BuiltinSerializers.STRING);
            idLookupBuilder.put((Object)idCounter.getAndIncrement(), (Object)BuiltinSerializers.STRING);
            serializerLookupBuilder.put((Object)DirectionSerializer.REF, (Object)BuiltinSerializers.DIRECTION);
            idLookupBuilder.put((Object)idCounter.getAndIncrement(), (Object)BuiltinSerializers.DIRECTION);
            serializerLookupBuilder.put((Object)UUIDSerializer.REF, (Object)BuiltinSerializers.UUID);
            idLookupBuilder.put((Object)idCounter.getAndIncrement(), (Object)BuiltinSerializers.UUID);
            serializerLookupBuilder.put((Object)Vec2Serializer.REF, (Object)BuiltinSerializers.VEC2);
            idLookupBuilder.put((Object)idCounter.getAndIncrement(), (Object)BuiltinSerializers.VEC2);
            serializerLookupBuilder.put((Object)Vec3Serializer.REF, (Object)BuiltinSerializers.VEC3);
            idLookupBuilder.put((Object)idCounter.getAndIncrement(), (Object)BuiltinSerializers.VEC3);
            serializerLookupBuilder.put((Object)BlockPosSerializer.REF, (Object)BuiltinSerializers.BLOCK_POS);
            idLookupBuilder.put((Object)idCounter.getAndIncrement(), (Object)BuiltinSerializers.BLOCK_POS);
            serializerLookupBuilder.put((Object)ItemStackSerializer.REF, (Object)BuiltinSerializers.ITEM_STACK);
            idLookupBuilder.put((Object)idCounter.getAndIncrement(), (Object)BuiltinSerializers.ITEM_STACK);
            serializerLookupBuilder.put((Object)ItemSerializer.REF, (Object)BuiltinSerializers.ITEM);
            idLookupBuilder.put((Object)idCounter.getAndIncrement(), (Object)BuiltinSerializers.ITEM);
            serializerLookupBuilder.put((Object)ResourceLocationSerializer.REF, (Object)BuiltinSerializers.RESOURCE_LOCATION);
            idLookupBuilder.put((Object)idCounter.getAndIncrement(), (Object)BuiltinSerializers.RESOURCE_LOCATION);
            serializerLookupBuilder.put((Object)ParticleOptionsSerializer.REF, (Object)BuiltinSerializers.PARTICLE_OPTIONS);
            idLookupBuilder.put((Object)idCounter.getAndIncrement(), (Object)BuiltinSerializers.PARTICLE_OPTIONS);
            serializerLookupBuilder.put((Object)EntitySerializer.REF, (Object)BuiltinSerializers.ENTITY);
            idLookupBuilder.put((Object)idCounter.getAndIncrement(), (Object)BuiltinSerializers.ENTITY);
            serializerLookupBuilder.put((Object)EntityReferenceSerializer.REF, (Object)BuiltinSerializers.ENTITY_REFERENCE);
            idLookupBuilder.put((Object)idCounter.getAndIncrement(), (Object)BuiltinSerializers.ENTITY_REFERENCE);
        }

        public Built build() {
            MutableInt idCounter = new MutableInt(0);
            NotBuilt.bootstrap(this.serializerLookupBuilder, this.idLookupBuilder, idCounter);
            this.serializerLookupBuilder.put((Object)IntSchedulerSerializer.REF, (Object)BCSerializers.INT_SCHEDULER);
            this.idLookupBuilder.put((Object)idCounter.getAndIncrement(), (Object)BCSerializers.INT_SCHEDULER);
            this.serializerLookupBuilder.put((Object)RangedIntSchedulerSerializer.REF, (Object)BCSerializers.RANGED_INT_SCHEDULER);
            this.idLookupBuilder.put((Object)idCounter.getAndIncrement(), (Object)BCSerializers.RANGED_INT_SCHEDULER);
            this.serializerLookupBuilder.put((Object)VariableIntSchedulerSerializer.REF, (Object)BCSerializers.VARIABLE_INT_SCHEDULER);
            this.idLookupBuilder.put((Object)idCounter.getAndIncrement(), (Object)BCSerializers.VARIABLE_INT_SCHEDULER);
            MinecraftForge.EVENT_BUS.post((Event)new SerializerLookupBuildingEvent(this.serializerLookupBuilder, this.idLookupBuilder, idCounter));
            return new Built((Map<ResourceLocation, SerializerMark<?>>)this.serializerLookupBuilder.build(), (BiMap<Integer, SerializerMark<?>>)this.idLookupBuilder.build());
        }

        @Override
        public int getIdFromSerializer(SerializerMark<?> serializer) {
            throw UNBUILT_LOOKUP_EX;
        }

        @Override
        public SerializerMark<?> getSerializerFromId(int id) {
            throw UNBUILT_LOOKUP_EX;
        }
    }

    public static class Built
    implements SerializerLookup {
        private final Map<ResourceLocation, SerializerMark<?>> serializerLookupMap;
        private final BiMap<Integer, SerializerMark<?>> serializerIdLookupBimap;

        private Built(Map<ResourceLocation, SerializerMark<?>> serializerLookup, BiMap<Integer, SerializerMark<?>> serializerIdBimap) {
            this.serializerLookupMap = serializerLookup;
            this.serializerIdLookupBimap = serializerIdBimap;
        }

        @Override
        public int getIdFromSerializer(SerializerMark<?> serializer) {
            return (Integer)this.serializerIdLookupBimap.inverse().get(serializer);
        }

        @Override
        public SerializerMark<?> getSerializerFromId(int id) {
            return (SerializerMark)this.serializerIdLookupBimap.get((Object)id);
        }
    }
}

