/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._mod.common_sided;

import bottomtextdanny.braincell.mod._base.registry.EggBuildData;
import bottomtextdanny.braincell.mod._mod.common_sided.EntityAttributeDeferror;
import bottomtextdanny.braincell.mod._mod.common_sided.EntitySpawnDeferring;
import bottomtextdanny.braincell.mod.world.builtin_items.BCSpawnEggItem;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public final class EntityCoreDataDeferror {
    private final List<BCSpawnEggItem> eggs = Lists.newLinkedList();
    private final List<EntitySpawnDeferring<?>> deferredSpawnPlacements = Lists.newLinkedList();
    private final List<EntityAttributeDeferror> deferredAttributeAttachments = Lists.newLinkedList();
    private final Map<ResourceLocation, EggBuildData> eggBuilders = Maps.newIdentityHashMap();

    public void sendListeners() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(event -> {
            this.deferredSpawnPlacements.forEach(EntitySpawnDeferring::put);
            this.close();
        });
        bus.addListener(event -> this.deferredAttributeAttachments.forEach(deferror -> deferror.register((EntityAttributeCreationEvent)event)));
        bus.addGenericListener(EntityType.class, EventPriority.LOWEST, event -> {
            DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior(){

                public ItemStack m_7498_(BlockSource source, ItemStack stack) {
                    Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                    EntityType entitytype = ((SpawnEggItem)stack.m_41720_()).m_43228_(stack.m_41783_());
                    entitytype.m_20592_(source.m_7727_(), stack, null, source.m_7961_().m_142300_(direction), MobSpawnType.DISPENSER, direction != Direction.UP, false);
                    stack.m_41774_(1);
                    return stack;
                }
            };
            Map EGGS = SpawnEggItem.f_43201_;
            this.eggs.forEach(egg -> {
                EGGS.put(egg.m_43228_(null), egg);
                DispenserBlock.m_52672_((ItemLike)egg, (DispenseItemBehavior)defaultDispenseItemBehavior);
            });
        });
    }

    public void saveEggBuilder(ResourceLocation key, EggBuildData builder) {
        if (builder == null) {
            return;
        }
        this.eggBuilders.putIfAbsent(key, builder);
    }

    public void putEgg(BCSpawnEggItem egg) {
        this.eggs.add(egg);
    }

    public EggBuildData getEggBuilder(ResourceLocation key) {
        return this.eggBuilders.getOrDefault(key, null);
    }

    public void deferSpawnPlacement(EntitySpawnDeferring<?> spawnDeferring) {
        this.deferredSpawnPlacements.add(spawnDeferring);
    }

    public void deferAttributeAttachment(EntityAttributeDeferror attributeDeferror) {
        this.deferredAttributeAttachments.add(attributeDeferror);
    }

    public void close() {
        this.eggs.clear();
        this.deferredAttributeAttachments.clear();
        this.eggBuilders.clear();
        this.deferredSpawnPlacements.clear();
    }
}

