/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._mod.common_sided;

import bottomtextdanny.braincell.Braincell;
import bottomtextdanny.braincell.mod._base.registry.block_extensions.BCBlockSolvingHook;
import bottomtextdanny.braincell.mod._base.registry.item_extensions.ExtraItemModelLoader;
import bottomtextdanny.braincell.mod._base.registry.managing.DeferrorType;
import bottomtextdanny.braincell.mod._mod.common_sided.SolvingHook;
import bottomtextdanny.braincell.mod.network.Connection;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class DefaultSolvingHooks {
    private final Map<DeferrorType<?>, SolvingHook<?>> hooks = Maps.newIdentityHashMap();

    public DefaultSolvingHooks() {
        this.addHook(DeferrorType.BLOCK, new BCBlockSolvingHook());
        Connection.doClientSide(() -> this.addHook(DeferrorType.ITEM, (item, solving) -> {
            if (item instanceof ExtraItemModelLoader) {
                ExtraItemModelLoader modelLoader = (ExtraItemModelLoader)item;
                Braincell.client().getExtraModelLoaders().addModelLoader(modelLoader);
            }
        }));
    }

    private <T extends IForgeRegistryEntry<T>> void addHook(DeferrorType<T> type, SolvingHook<T> hook) {
        if (this.hooks.containsKey(type)) {
            this.hooks.put(type, this.hooks.get(type).append(hook));
        } else {
            this.hooks.put(type, hook);
        }
    }

    @Nullable
    public <T extends IForgeRegistryEntry<T>> SolvingHook<T> getHook(DeferrorType<T> type) {
        if (this.hooks.containsKey(type)) {
            return this.hooks.get(type);
        }
        return null;
    }
}

